/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view.component;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import jd.core.links.HyperlinkData;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.jd.gui.view.component.TextPage;

public abstract class HyperlinkPage
extends TextPage {
    private static final long serialVersionUID = 1L;
    protected static final Cursor DEFAULT_CURSOR = Cursor.getDefaultCursor();
    protected static final Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);
    protected final transient NavigableMap<Integer, HyperlinkData> hyperlinks = new TreeMap<Integer, HyperlinkData>();

    protected HyperlinkPage() {
        MouseAdapter listener = new MouseAdapter(){
            private int lastX = -1;
            private int lastY = -1;
            private int lastModifiers = -1;

            @Override
            public void mouseClicked(MouseEvent e) {
                HyperlinkData entryData;
                Map.Entry<Integer, HyperlinkData> entry;
                int offset;
                if (e.getClickCount() == 1 && (e.getModifiersEx() & 0x340) == 0 && (offset = HyperlinkPage.this.textArea.viewToModel2D((Point2D)new Point(e.getX(), e.getY()))) != -1 && (entry = HyperlinkPage.this.hyperlinks.floorEntry(offset)) != null && (entryData = entry.getValue()) != null && offset < entryData.getEndPosition() && offset >= entryData.getStartPosition() && HyperlinkPage.this.isHyperlinkEnabled(entryData)) {
                    HyperlinkPage.this.openHyperlink(e.getXOnScreen(), e.getYOnScreen(), entryData);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (e.getX() != this.lastX || e.getY() != this.lastY || this.lastModifiers != e.getModifiersEx()) {
                    HyperlinkData entryData;
                    Map.Entry<Integer, HyperlinkData> entry;
                    int offset;
                    this.lastX = e.getX();
                    this.lastY = e.getY();
                    this.lastModifiers = e.getModifiersEx();
                    if ((e.getModifiersEx() & 0x340) == 0 && (offset = HyperlinkPage.this.textArea.viewToModel2D((Point2D)new Point(e.getX(), e.getY()))) != -1 && (entry = HyperlinkPage.this.hyperlinks.floorEntry(offset)) != null && (entryData = entry.getValue()) != null && offset < entryData.getEndPosition() && offset >= entryData.getStartPosition() && HyperlinkPage.this.isHyperlinkEnabled(entryData)) {
                        if (HyperlinkPage.this.textArea.getCursor() != HAND_CURSOR) {
                            HyperlinkPage.this.textArea.setCursor(HAND_CURSOR);
                        }
                        return;
                    }
                    if (HyperlinkPage.this.textArea.getCursor() != DEFAULT_CURSOR) {
                        HyperlinkPage.this.textArea.setCursor(DEFAULT_CURSOR);
                    }
                }
            }
        };
        this.textArea.addMouseListener((MouseListener)listener);
        this.textArea.addMouseMotionListener((MouseMotionListener)listener);
    }

    @Override
    protected RSyntaxTextArea newSyntaxTextArea() {
        return new HyperlinkSyntaxTextArea();
    }

    public void addHyperlink(HyperlinkData hyperlinkData) {
        this.hyperlinks.put(hyperlinkData.getStartPosition(), hyperlinkData);
    }

    public void clearHyperlinks() {
        this.hyperlinks.clear();
    }

    protected abstract boolean isHyperlinkEnabled(HyperlinkData var1);

    protected abstract void openHyperlink(int var1, int var2, HyperlinkData var3);

    public class HyperlinkSyntaxTextArea
    extends RSyntaxTextArea {
        private static final long serialVersionUID = 1L;

        public boolean getUnderlineForToken(Token t) {
            HyperlinkData entryData;
            Map.Entry<Integer, HyperlinkData> entry = HyperlinkPage.this.hyperlinks.floorEntry(t.getOffset());
            if (entry != null && (entryData = entry.getValue()) != null && t.getOffset() < entryData.getEndPosition() && t.getOffset() >= entryData.getStartPosition() && HyperlinkPage.this.isHyperlinkEnabled(entryData)) {
                return true;
            }
            return super.getUnderlineForToken(t);
        }
    }
}

