/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view.component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import jd.core.links.DeclarationData;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.jd.gui.api.model.Container;
import org.jd.gui.util.Key;
import org.jd.gui.util.parser.jdt.core.AbstractJavaListener;
import org.jd.gui.util.parser.jdt.core.TypeDeclarationData;

public class DeclarationListener
extends AbstractJavaListener {
    private final StringBuilder sbTypeDeclaration = new StringBuilder();
    private String currentInternalTypeName;
    private final Map<String, DeclarationData> declarations = new HashMap<String, DeclarationData>();
    private final NavigableMap<Integer, DeclarationData> typeDeclarations = new TreeMap<Integer, DeclarationData>();

    public DeclarationListener(Container.Entry entry) {
        super(entry);
    }

    public Map<String, String> getNameToInternalTypeName() {
        return this.nameToInternalTypeName;
    }

    @Override
    public boolean visit(PackageDeclaration node) {
        if (super.visit(node) && !this.packageName.isEmpty()) {
            this.sbTypeDeclaration.append(this.packageName).append('/');
        }
        return true;
    }

    @Override
    protected boolean enterTypeDeclaration(AbstractTypeDeclaration node, int flag) {
        String typeName = node.getName().getIdentifier();
        int position = node.getName().getStartPosition();
        int length = this.sbTypeDeclaration.length();
        if (length == 0 || this.sbTypeDeclaration.charAt(length - 1) == '/') {
            this.sbTypeDeclaration.append(typeName);
        } else {
            this.sbTypeDeclaration.append('$').append(typeName);
        }
        this.currentInternalTypeName = this.sbTypeDeclaration.toString();
        this.nameToInternalTypeName.put(typeName, this.currentInternalTypeName);
        Type superType = this.getSuperType(node);
        String superInternalTypeName = superType != null ? this.resolveInternalTypeName(superType) : null;
        TypeDeclarationData data = new TypeDeclarationData(position, typeName.length(), this.currentInternalTypeName, superInternalTypeName);
        this.declarations.put(this.currentInternalTypeName, data);
        this.typeDeclarations.put(position, data);
        return true;
    }

    @Override
    public void exitTypeDeclaration() {
        int index = this.sbTypeDeclaration.lastIndexOf("$");
        if (index == -1) {
            index = this.sbTypeDeclaration.lastIndexOf("/") + 1;
        }
        if (index == -1) {
            this.sbTypeDeclaration.setLength(0);
        } else {
            this.sbTypeDeclaration.setLength(index);
        }
        this.currentInternalTypeName = this.sbTypeDeclaration.toString();
    }

    public boolean visit(Initializer node) {
        int position = node.getStartPosition();
        String key = Key.key(this.currentInternalTypeName, "<clinit>", "()V");
        TypeDeclarationData data = new TypeDeclarationData(position, 6, this.currentInternalTypeName, "()V");
        this.declarations.put(key, data);
        return true;
    }

    public boolean visit(FieldDeclaration node) {
        List fragments = node.fragments();
        for (VariableDeclarationFragment fragment : fragments) {
            String name = fragment.getName().getIdentifier();
            int dimensionOnVariable = fragment.getExtraDimensions();
            int position = fragment.getName().getStartPosition();
            String descriptor = this.createDescriptor(node.getType(), dimensionOnVariable);
            String key = Key.key(this.currentInternalTypeName, name, descriptor);
            DeclarationData data = new DeclarationData(position, name.length(), this.currentInternalTypeName, name, descriptor);
            this.declarations.put(key, data);
        }
        return true;
    }

    public boolean visit(MethodDeclaration node) {
        SimpleName nodeName = node.getName();
        String name = nodeName.getIdentifier();
        String paramDescriptors = this.createParamDescriptors(node.parameters());
        String returnDescriptor = this.createDescriptor(node.getReturnType2(), 0);
        String descriptor = paramDescriptors + returnDescriptor;
        int position = nodeName.getStartPosition();
        String key = Key.key(this.currentInternalTypeName, node.isConstructor() ? "<init>" : name, descriptor);
        DeclarationData data = new DeclarationData(position, nodeName.getLength(), this.currentInternalTypeName, name, descriptor);
        this.declarations.put(key, data);
        return true;
    }

    public Map<String, DeclarationData> getDeclarations() {
        return this.declarations;
    }

    public NavigableMap<Integer, DeclarationData> getTypeDeclarations() {
        return this.typeDeclarations;
    }

    public void clearData() {
        this.sbTypeDeclaration.setLength(0);
        this.declarations.clear();
        this.typeDeclarations.clear();
    }

    public void addTypeDeclaration(int position, String internalName, DeclarationData data) {
        this.typeDeclarations.put(position, data);
        this.declarations.put(internalName, data);
    }

    public void addDeclaration(String key, DeclarationData declarationData) {
        this.declarations.put(key, declarationData);
    }
}

