/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view.component;

import com.heliosdecompiler.transformerapi.StandardTransformers;
import com.heliosdecompiler.transformerapi.common.Loader;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import jd.core.ClassUtil;
import jd.core.DecompilationResult;
import org.fife.ui.rsyntaxtextarea.DocumentRange;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.util.MethodPatcher;
import org.jd.gui.util.decompiler.ContainerLoader;
import org.jd.gui.util.loader.LoaderUtils;
import org.jd.gui.util.parser.jdt.core.manipulation.RemoveUnnecessaryCasts;
import org.jd.gui.view.component.TypePage;

public class ClassFilePage
extends TypePage {
    private static final String INTERNAL_ERROR = "// INTERNAL ERROR //";
    private static final long serialVersionUID = 1L;
    private int maximumLineNumber = -1;

    public ClassFilePage(API api, Container.Entry entry) {
        super(api, entry);
        Map<String, String> preferences = api.getPreferences();
        this.setErrorForeground(Color.decode(preferences.get("JdGuiPreferences.errorBackgroundColor")));
        this.decompile(preferences);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decompile(Map<String, String> preferences) {
        boolean realignmentLineNumbers = "true".equals(preferences.get("ClassFileSaverPreferences.realignLineNumbers")) || "true".equals(preferences.get("StretchLines"));
        boolean removeUnnecessaryCasts = "true".equals(preferences.get("ClassFileDecompilerPreferences.removeUnnecessaryCasts"));
        this.setShowMisalignment(realignmentLineNumbers);
        ContainerLoader loader = new ContainerLoader(this.entry);
        try {
            this.clearLineNumbers();
            this.listener.clearData();
            String entryInternalName = ClassUtil.getInternalName((String)this.entry.getPath());
            String engineName = preferences.getOrDefault("ClassFileDecompilerPreferences.decompileEngine", "JD-Core v1");
            Loader apiLoader = LoaderUtils.createLoader(preferences, loader, this.entry);
            DecompilationResult decompilationResult = StandardTransformers.decompile((Loader)apiLoader, (String)entryInternalName, preferences, (String)engineName);
            if (decompilationResult.getDecompiledOutput().contains("Decompilation failed at line #")) {
                DecompilationResult sourceCodeV0 = StandardTransformers.decompile((Loader)apiLoader, (String)entryInternalName, preferences, (String)"JD-Core v0");
                String patchedCode = MethodPatcher.patchCode(decompilationResult.getDecompiledOutput(), sourceCodeV0.getDecompiledOutput(), this.entry);
                if (removeUnnecessaryCasts) {
                    patchedCode = new RemoveUnnecessaryCasts(this.entry).process(patchedCode);
                }
                this.parseAndSetText(patchedCode);
            } else {
                this.listener.getStrings().addAll(decompilationResult.getStrings());
                this.listener.getTypeDeclarations().putAll(decompilationResult.getTypeDeclarations());
                this.listener.getDeclarations().putAll(decompilationResult.getDeclarations());
                this.listener.getReferences().addAll(decompilationResult.getReferences());
                this.hyperlinks.putAll(decompilationResult.getHyperlinks());
                if (decompilationResult.getMaxLineNumber() != 0) {
                    this.setMaxLineNumber(decompilationResult.getMaxLineNumber());
                }
                for (Map.Entry entry : decompilationResult.getLineNumbers().entrySet()) {
                    Integer textAreaLineNumber = (Integer)entry.getKey();
                    Integer sourceLineNumber = (Integer)entry.getValue();
                    this.setLineNumber(textAreaLineNumber, sourceLineNumber);
                }
                if (this.hyperlinks.isEmpty() || removeUnnecessaryCasts) {
                    if (removeUnnecessaryCasts) {
                        decompilationResult.setDecompiledOutput(new RemoveUnnecessaryCasts(this.entry).process(decompilationResult.getDecompiledOutput()));
                    }
                    this.parseAndSetText(decompilationResult.getDecompiledOutput());
                } else {
                    this.setText(decompilationResult.getDecompiledOutput());
                }
            }
        }
        catch (Exception t) {
            assert (ExceptionUtil.printStackTrace((Throwable)t));
            this.setText(INTERNAL_ERROR);
        }
        finally {
            this.maximumLineNumber = this.getMaximumSourceLineNumber();
        }
    }

    @Override
    public String getSyntaxStyle() {
        return "text/java";
    }

    @Override
    public String getFileName() {
        String path = this.entry.getPath();
        int index = path.lastIndexOf(46);
        return path.substring(0, index) + ".java";
    }

    @Override
    public void save(API api, OutputStream os) {
        block11: {
            DecompilationResult decompilationResult = new DecompilationResult();
            ContainerLoader loader = new ContainerLoader(this.entry);
            try {
                Map<String, String> preferences = api.getPreferences();
                String entryInternalName = ClassUtil.getInternalName((String)this.entry.getPath());
                String decompileEngine = preferences.getOrDefault("ClassFileDecompilerPreferences.decompileEngine", "JD-Core v1");
                Loader apiLoader = LoaderUtils.createLoader(preferences, loader, this.entry);
                decompilationResult = StandardTransformers.decompile((Loader)apiLoader, (String)entryInternalName, preferences, (String)decompileEngine);
                if (decompilationResult.getDecompiledOutput().contains("Decompilation failed at line #")) {
                    DecompilationResult sourceCodeV0 = StandardTransformers.decompile((Loader)apiLoader, (String)entryInternalName, preferences, (String)"JD-Core v0");
                    decompilationResult.setDecompiledOutput(MethodPatcher.patchCode(decompilationResult.getDecompiledOutput(), sourceCodeV0.getDecompiledOutput(), this.entry));
                }
            }
            catch (Exception t) {
                assert (ExceptionUtil.printStackTrace((Throwable)t));
                decompilationResult.setDecompiledOutput(INTERNAL_ERROR);
            }
            try (PrintStream ps = new PrintStream(os, true, StandardCharsets.UTF_8.name());){
                ps.print(decompilationResult.getDecompiledOutput());
            }
            catch (IOException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block11;
                throw new AssertionError();
            }
        }
    }

    @Override
    public int getMaximumLineNumber() {
        return this.maximumLineNumber;
    }

    @Override
    public void goToLineNumber(int lineNumber) {
        block3: {
            int textAreaLineNumber = this.getTextAreaLineNumber(lineNumber);
            if (textAreaLineNumber > 0) {
                try {
                    int start = this.textArea.getLineStartOffset(textAreaLineNumber - 1);
                    int end = this.textArea.getLineEndOffset(textAreaLineNumber - 1);
                    this.setCaretPositionAndCenter(new DocumentRange(start, end));
                }
                catch (BadLocationException e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block3;
                    throw new AssertionError();
                }
            }
        }
    }

    @Override
    public boolean checkLineNumber(int lineNumber) {
        return lineNumber <= this.maximumLineNumber;
    }

    @Override
    public void preferencesChanged(Map<String, String> preferences) {
        DefaultCaret caret = (DefaultCaret)this.textArea.getCaret();
        int updatePolicy = caret.getUpdatePolicy();
        caret.setUpdatePolicy(1);
        this.decompile(preferences);
        caret.setUpdatePolicy(updatePolicy);
        super.preferencesChanged(preferences);
        this.indexesChanged(this.collectionOfFutureIndexes);
    }
}

