/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view.component;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.DocumentRange;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaEditorKit;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;
import org.fife.ui.rtextarea.FoldIndicatorStyle;
import org.fife.ui.rtextarea.Gutter;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.rtextarea.SearchResult;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.feature.ContentSearchable;
import org.jd.gui.api.feature.LineNumberNavigable;
import org.jd.gui.api.feature.PreferencesChangeListener;
import org.jd.gui.api.feature.UriOpenable;
import org.jd.gui.view.component.RoundMarkErrorStrip;

public class AbstractTextPage
extends JPanel
implements LineNumberNavigable,
ContentSearchable,
UriOpenable,
PreferencesChangeListener {
    private static final long serialVersionUID = 1L;
    protected static final Color DOUBLE_CLICK_HIGHLIGHT_COLOR = new Color(0x66FF66);
    protected static final Color SEARCH_HIGHLIGHT_COLOR = new Color(0xFFFF66);
    protected static final Color SELECT_HIGHLIGHT_COLOR = new Color(16029712);
    protected static final RSyntaxTextAreaEditorKit.DecreaseFontSizeAction DECREASE_FONT_SIZE_ACTION = new RSyntaxTextAreaEditorKit.DecreaseFontSizeAction();
    protected static final RSyntaxTextAreaEditorKit.IncreaseFontSizeAction INCREASE_FONT_SIZE_ACTION = new RSyntaxTextAreaEditorKit.IncreaseFontSizeAction();
    protected final RSyntaxTextArea textArea;
    protected final RTextScrollPane scrollPane;
    private Map<String, String> preferences;

    public AbstractTextPage() {
        MouseWheelListener[] mouseWheelListeners;
        block9: {
            super(new BorderLayout());
            this.textArea = this.newSyntaxTextArea();
            this.textArea.setSyntaxEditingStyle(this.getSyntaxStyle());
            this.textArea.setCodeFoldingEnabled(true);
            this.textArea.setAntiAliasingEnabled(true);
            this.textArea.setCaretPosition(0);
            this.textArea.setEditable(false);
            this.textArea.setDropTarget(null);
            this.textArea.setPopupMenu(null);
            this.textArea.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        AbstractTextPage.this.textArea.setMarkAllHighlightColor(DOUBLE_CLICK_HIGHLIGHT_COLOR);
                        SearchEngine.markAll((RTextArea)AbstractTextPage.this.textArea, (SearchContext)AbstractTextPage.this.newSearchContext(AbstractTextPage.this.textArea.getSelectedText(), true, true, true, false));
                    }
                }
            });
            KeyStroke ctrlA = KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
            KeyStroke ctrlC = KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
            KeyStroke ctrlV = KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
            InputMap inputMap = this.textArea.getInputMap();
            inputMap.put(ctrlA, "none");
            inputMap.put(ctrlC, "none");
            inputMap.put(ctrlV, "none");
            try (InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("rsyntaxtextarea/themes/eclipse.xml");){
                MouseWheelListener[] theme = Theme.load((InputStream)resourceAsStream);
                theme.apply(this.textArea);
            }
            catch (IOException e2) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e2)) break block9;
                throw new AssertionError();
            }
        }
        this.scrollPane = new RTextScrollPane((RTextArea)this.textArea);
        this.scrollPane.setFoldIndicatorEnabled(true);
        this.scrollPane.setFont(this.textArea.getFont());
        for (MouseWheelListener listener : mouseWheelListeners = this.scrollPane.getMouseWheelListeners()) {
            this.scrollPane.removeMouseWheelListener(listener);
        }
        this.scrollPane.addMouseWheelListener(e -> {
            if ((e.getModifiersEx() & 0x180) != 0) {
                int x = e.getX() + this.scrollPane.getX() - this.textArea.getX();
                int y = e.getY() + this.scrollPane.getY() - this.textArea.getY();
                int offset = this.textArea.viewToModel2D((Point2D)new Point(x, y));
                if (e.getWheelRotation() > 0) {
                    DECREASE_FONT_SIZE_ACTION.actionPerformedImpl(null, (RTextArea)this.textArea);
                } else {
                    INCREASE_FONT_SIZE_ACTION.actionPerformedImpl(null, (RTextArea)this.textArea);
                }
                if (this.preferences != null) {
                    this.preferences.put("ViewerPreferences.fontSize", String.valueOf(this.textArea.getFont().getSize()));
                }
                try {
                    Rectangle2D newRectangle = this.textArea.modelToView2D(offset);
                    int newY = (int)Math.round(newRectangle.getY() + newRectangle.getHeight() / 2.0);
                    Point viewPosition = this.scrollPane.getViewport().getViewPosition();
                    viewPosition.y = Math.max(viewPosition.y + newY - y, 0);
                    this.scrollPane.getViewport().setViewPosition(viewPosition);
                }
                catch (BadLocationException ee) {
                    assert (ExceptionUtil.printStackTrace((Throwable)ee));
                }
            } else {
                for (MouseWheelListener listener : mouseWheelListeners) {
                    listener.mouseWheelMoved(e);
                }
            }
        });
        Gutter gutter = this.scrollPane.getGutter();
        gutter.setFoldIndicatorStyle(FoldIndicatorStyle.CLASSIC);
        gutter.setFoldIndicatorForeground(gutter.getBorderColor());
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)new RoundMarkErrorStrip(this.textArea), "After");
    }

    protected RSyntaxTextArea newSyntaxTextArea() {
        return new RSyntaxTextArea();
    }

    public String getText() {
        return this.textArea.getText();
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    protected void setText(String text) {
        this.textArea.setText(text);
        this.textArea.setCaretPosition(0);
    }

    public String getSyntaxStyle() {
        return "text/plain";
    }

    protected void setCaretPositionAndCenter(DocumentRange range) {
        block6: {
            int start = range.getStartOffset();
            int end = range.getEndOffset();
            boolean foldsExpanded = false;
            FoldManager fm = this.textArea.getFoldManager();
            if (fm.isCodeFoldingSupportedAndEnabled()) {
                foldsExpanded = fm.ensureOffsetNotInClosedFold(start);
                foldsExpanded |= fm.ensureOffsetNotInClosedFold(end);
            }
            if (!foldsExpanded) {
                try {
                    Rectangle2D rec = this.textArea.modelToView2D(start);
                    if (rec != null) {
                        this.setCaretPositionAndCenter(start, end, rec);
                    } else {
                        SwingUtilities.invokeLater(() -> {
                            block3: {
                                try {
                                    Rectangle2D r = this.textArea.modelToView2D(start);
                                    if (r != null) {
                                        this.setCaretPositionAndCenter(start, end, r);
                                    }
                                }
                                catch (BadLocationException e) {
                                    if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block3;
                                    throw new AssertionError();
                                }
                            }
                        });
                    }
                }
                catch (BadLocationException e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block6;
                    throw new AssertionError();
                }
            }
        }
    }

    protected void setCaretPositionAndCenter(int start, int end, Rectangle2D rec) {
        block5: {
            if (end != start) {
                try {
                    rec = rec.createUnion(this.textArea.modelToView2D(end));
                }
                catch (BadLocationException e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block5;
                    throw new AssertionError();
                }
            }
        }
        Rectangle visible = this.textArea.getVisibleRect();
        visible.y = (int)Math.round(rec.getY() - ((double)visible.height - rec.getHeight()) / 2.0);
        Rectangle bounds = this.textArea.getBounds();
        Insets i = this.textArea.getInsets();
        bounds.y = i.top;
        bounds.height -= i.top + i.bottom;
        if (visible.y < bounds.y) {
            visible.y = bounds.y;
        }
        if (visible.y + visible.height > bounds.y + bounds.height) {
            visible.y = bounds.y + bounds.height - visible.height;
        }
        this.textArea.scrollRectToVisible(visible);
        this.textArea.setCaretPosition(start);
    }

    @Override
    public int getMaximumLineNumber() {
        try {
            return this.textArea.getLineOfOffset(this.textArea.getDocument().getLength()) + 1;
        }
        catch (BadLocationException e) {
            assert (ExceptionUtil.printStackTrace((Throwable)e));
            return 0;
        }
    }

    @Override
    public void goToLineNumber(int lineNumber) {
        block2: {
            try {
                this.textArea.setCaretPosition(this.textArea.getLineStartOffset(lineNumber - 1));
            }
            catch (BadLocationException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block2;
                throw new AssertionError();
            }
        }
    }

    @Override
    public boolean checkLineNumber(int lineNumber) {
        return true;
    }

    @Override
    public boolean highlightText(String text, boolean caseSensitive) {
        if (text.length() > 1) {
            this.textArea.setMarkAllHighlightColor(SEARCH_HIGHLIGHT_COLOR);
            this.textArea.setCaretPosition(this.textArea.getSelectionStart());
            SearchContext context = this.newSearchContext(text, caseSensitive, false, true, false);
            SearchResult result = SearchEngine.find((JTextArea)this.textArea, (SearchContext)context);
            if (!result.wasFound()) {
                this.textArea.setCaretPosition(0);
                result = SearchEngine.find((JTextArea)this.textArea, (SearchContext)context);
            }
            return result.wasFound();
        }
        return true;
    }

    @Override
    public void findNext(String text, boolean caseSensitive) {
        if (text.length() > 1) {
            this.textArea.setMarkAllHighlightColor(SEARCH_HIGHLIGHT_COLOR);
            SearchContext context = this.newSearchContext(text, caseSensitive, false, true, false);
            SearchResult result = SearchEngine.find((JTextArea)this.textArea, (SearchContext)context);
            if (!result.wasFound()) {
                this.textArea.setCaretPosition(0);
                SearchEngine.find((JTextArea)this.textArea, (SearchContext)context);
            }
        }
    }

    @Override
    public void findPrevious(String text, boolean caseSensitive) {
        if (text.length() > 1) {
            this.textArea.setMarkAllHighlightColor(SEARCH_HIGHLIGHT_COLOR);
            SearchContext context = this.newSearchContext(text, caseSensitive, false, false, false);
            SearchResult result = SearchEngine.find((JTextArea)this.textArea, (SearchContext)context);
            if (!result.wasFound()) {
                this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
                SearchEngine.find((JTextArea)this.textArea, (SearchContext)context);
            }
        }
    }

    protected SearchContext newSearchContext(String searchFor, boolean matchCase, boolean wholeWord, boolean searchForward, boolean regexp) {
        SearchContext context = new SearchContext(searchFor, matchCase);
        context.setMarkAll(true);
        context.setWholeWord(wholeWord);
        context.setSearchForward(searchForward);
        context.setRegularExpression(regexp);
        return context;
    }

    @Override
    public boolean openUri(URI uri) {
        block12: {
            String query = uri.getQuery();
            if (query != null) {
                String highlightFlags;
                Map<String, String> parameters = this.parseQuery(query);
                if (parameters.containsKey("lineNumber")) {
                    String lineNumber = parameters.get("lineNumber");
                    try {
                        this.goToLineNumber(Integer.parseInt(lineNumber));
                        return true;
                    }
                    catch (NumberFormatException e) {
                        assert (ExceptionUtil.printStackTrace((Throwable)e));
                        break block12;
                    }
                }
                if (parameters.containsKey("position")) {
                    String position = parameters.get("position");
                    try {
                        int pos = Integer.parseInt(position);
                        if (this.textArea.getDocument().getLength() > pos) {
                            this.setCaretPositionAndCenter(new DocumentRange(pos, pos));
                            return true;
                        }
                        break block12;
                    }
                    catch (NumberFormatException e) {
                        assert (ExceptionUtil.printStackTrace((Throwable)e));
                        break block12;
                    }
                }
                if (parameters.containsKey("highlightFlags") && (highlightFlags = parameters.get("highlightFlags")).indexOf(115) != -1 && parameters.containsKey("highlightPattern")) {
                    this.textArea.setMarkAllHighlightColor(SELECT_HIGHLIGHT_COLOR);
                    this.textArea.setCaretPosition(0);
                    String searchFor = AbstractTextPage.createRegExp(parameters.get("highlightPattern"));
                    SearchContext context = this.newSearchContext(searchFor, true, false, true, true);
                    SearchResult result = SearchEngine.find((JTextArea)this.textArea, (SearchContext)context);
                    if (result.getMatchRange() != null) {
                        this.textArea.setCaretPosition(result.getMatchRange().getStartOffset());
                    }
                    return true;
                }
            }
        }
        return false;
    }

    protected Map<String, String> parseQuery(String query) {
        HashMap<String, String> parameters;
        block4: {
            parameters = new HashMap<String, String>();
            try {
                for (String param : query.split("&")) {
                    int index = param.indexOf(61);
                    String enc = StandardCharsets.UTF_8.name();
                    if (index == -1) {
                        parameters.put(URLDecoder.decode(param, enc), "");
                        continue;
                    }
                    String key = param.substring(0, index);
                    String value = param.substring(index + 1);
                    parameters.put(URLDecoder.decode(key, enc), URLDecoder.decode(value, enc));
                }
            }
            catch (UnsupportedEncodingException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block4;
                throw new AssertionError();
            }
        }
        return parameters;
    }

    public static String createRegExp(String pattern) {
        int patternLength = pattern.length();
        StringBuilder sbPattern = new StringBuilder(patternLength * 2);
        block5: for (int i = 0; i < patternLength; ++i) {
            char c = pattern.charAt(i);
            switch (c) {
                case '*': {
                    sbPattern.append(".*");
                    continue block5;
                }
                case '?': {
                    sbPattern.append('.');
                    continue block5;
                }
                case '.': {
                    sbPattern.append("\\.");
                    continue block5;
                }
                default: {
                    sbPattern.append(c);
                }
            }
        }
        return sbPattern.toString();
    }

    @Override
    public void preferencesChanged(Map<String, String> preferences) {
        block3: {
            String fontSize = preferences.get("ViewerPreferences.fontSize");
            if (fontSize != null) {
                try {
                    this.textArea.setFont(this.textArea.getFont().deriveFont(Float.parseFloat(fontSize)));
                }
                catch (Exception e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block3;
                    throw new AssertionError();
                }
            }
        }
        this.preferences = preferences;
    }
}

