/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.TreeNodeExpandable;
import org.jd.gui.api.feature.UriGettable;
import org.jd.gui.api.model.Container;
import org.jd.gui.model.container.DelegatingFilterContainer;
import org.jd.gui.spi.TreeNodeFactory;
import org.jd.gui.util.swing.SwingUtil;
import org.jd.gui.view.component.Tree;
import org.jd.gui.view.renderer.TreeNodeRenderer;

public class SelectLocationView<T extends DefaultMutableTreeNode & UriGettable> {
    private final API api;
    private JDialog selectLocationDialog;
    private JLabel selectLocationLabel;
    private Tree selectLocationTree;
    private Consumer<URI> selectedEntryCallback;
    private Runnable closeCallback;

    public SelectLocationView(API api, JFrame mainFrame) {
        this.api = api;
        SwingUtil.invokeLater(() -> {
            this.selectLocationDialog = new JDialog(mainFrame, "", false);
            this.selectLocationDialog.setUndecorated(true);
            this.selectLocationDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowDeactivated(WindowEvent e) {
                    SelectLocationView.this.closeCallback.run();
                }
            });
            Color bg = UIManager.getColor("ToolTip.background");
            JPanel selectLocationPanel = new JPanel(new BorderLayout());
            selectLocationPanel.setBorder(BorderFactory.createLineBorder(bg.darker()));
            selectLocationPanel.setBackground(bg);
            this.selectLocationDialog.add(selectLocationPanel);
            this.selectLocationLabel = new JLabel();
            this.selectLocationLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
            selectLocationPanel.add((Component)this.selectLocationLabel, "North");
            this.selectLocationTree = new Tree();
            this.selectLocationTree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.selectLocationTree.setOpaque(false);
            this.selectLocationTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
            this.selectLocationTree.setCellRenderer(new TreeNodeRenderer());
            this.selectLocationTree.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        SelectLocationView.this.onSelectedEntry();
                    }
                }
            });
            this.selectLocationTree.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() > 0) {
                        SelectLocationView.this.onSelectedEntry();
                    }
                }
            });
            this.selectLocationTree.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    SelectLocationView.this.selectLocationDialog.setVisible(false);
                }
            });
            selectLocationPanel.add((Component)this.selectLocationTree, "Center");
            JRootPane rootPane = this.selectLocationDialog.getRootPane();
            rootPane.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "SelectLocationView.cancel");
            rootPane.getActionMap().put("SelectLocationView.cancel", new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectLocationView.this.selectLocationDialog.setVisible(false);
                }
            });
        });
    }

    public void show(Point location, Collection<DelegatingFilterContainer> containers, int locationCount, Consumer<URI> selectedEntryCallback, Runnable closeCallback) {
        this.selectedEntryCallback = selectedEntryCallback;
        this.closeCallback = closeCallback;
        SwingUtil.invokeLater(() -> {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.selectLocationTree.getModel().getRoot();
            root.removeAllChildren();
            ArrayList<DelegatingFilterContainer> sortedContainers = new ArrayList<DelegatingFilterContainer>(containers);
            sortedContainers.sort(Comparator.comparing(Container::getRootUri));
            for (DelegatingFilterContainer container : sortedContainers) {
                Object node;
                Container.Entry parentEntry = container.getRoot().getParent();
                TreeNodeFactory factory = this.api.getTreeNodeFactory(parentEntry);
                if (factory == null || (node = factory.make(this.api, parentEntry)) == null) continue;
                root.add((MutableTreeNode)node);
                this.populate(container.getUris(), (DefaultMutableTreeNode)node);
            }
            ((DefaultTreeModel)this.selectLocationTree.getModel()).reload();
            for (int row = 0; row < this.selectLocationTree.getRowCount(); ++row) {
                this.selectLocationTree.expandRow(row);
            }
            DefaultMutableTreeNode node = root;
            while (node.getChildCount() != 0) {
                node = (DefaultMutableTreeNode)node.getChildAt(0);
            }
            this.selectLocationTree.setSelectionPath(new TreePath(node.getPath()));
            this.selectLocationTree.setPreferredSize(null);
            Dimension ps = this.selectLocationTree.getPreferredSize();
            if (ps.width < 200) {
                ps.width = 200;
            }
            if (ps.height < 50) {
                ps.height = 50;
            }
            this.selectLocationTree.setPreferredSize(ps);
            this.selectLocationLabel.setText(locationCount + " locations:");
            this.selectLocationDialog.pack();
            this.selectLocationDialog.setLocation(location);
            this.selectLocationDialog.setVisible(true);
            this.selectLocationTree.requestFocus();
        });
    }

    protected void populate(Set<URI> uris, DefaultMutableTreeNode node) {
        if (node instanceof TreeNodeExpandable) {
            TreeNodeExpandable tne = (TreeNodeExpandable)((Object)node);
            tne.populateTreeNode(this.api);
            int i = node.getChildCount();
            while (i-- > 0) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                if (uris.contains(((UriGettable)((Object)child)).getUri())) {
                    this.populate(uris, child);
                    continue;
                }
                node.remove(i);
            }
        }
    }

    protected void onSelectedEntry() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.selectLocationTree.getLastSelectedPathComponent();
        if (node != null) {
            this.selectLocationDialog.setVisible(false);
            this.selectedEntryCallback.accept(((UriGettable)((Object)node)).getUri());
        }
    }
}

