/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.function.ObjIntConsumer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.TreeNodeExpandable;
import org.jd.gui.api.feature.UriGettable;
import org.jd.gui.api.model.Container;
import org.jd.gui.model.container.DelegatingFilterContainer;
import org.jd.gui.spi.TreeNodeFactory;
import org.jd.gui.util.function.TriConsumer;
import org.jd.gui.util.swing.SwingUtil;
import org.jd.gui.view.component.Tree;
import org.jd.gui.view.renderer.TreeNodeRenderer;

public class SearchInConstantPoolsView<T extends DefaultMutableTreeNode & UriGettable> {
    public static final int SEARCH_TYPE = 1;
    public static final int SEARCH_CONSTRUCTOR = 2;
    public static final int SEARCH_METHOD = 4;
    public static final int SEARCH_FIELD = 8;
    public static final int SEARCH_STRING = 16;
    public static final int SEARCH_MODULE = 32;
    public static final int SEARCH_DECLARATION = 64;
    public static final int SEARCH_REFERENCE = 128;
    private final API api;
    private final Set<URI> accepted = new HashSet<URI>();
    private final Set<URI> expanded = new HashSet<URI>();
    private JDialog searchInConstantPoolsDialog;
    private JTextField searchInConstantPoolsEnterTextField;
    private JLabel searchInConstantPoolsLabel;
    private JCheckBox searchInConstantPoolsCheckBoxType;
    private JCheckBox searchInConstantPoolsCheckBoxField;
    private JCheckBox searchInConstantPoolsCheckBoxConstructor;
    private JCheckBox searchInConstantPoolsCheckBoxMethod;
    private JCheckBox searchInConstantPoolsCheckBoxString;
    private JCheckBox searchInConstantPoolsCheckBoxModule;
    private JCheckBox searchInConstantPoolsCheckBoxDeclarations;
    private JCheckBox searchInConstantPoolsCheckBoxReferences;
    private Tree searchInConstantPoolsTree;

    public SearchInConstantPoolsView(API api, JFrame mainFrame, final ObjIntConsumer<String> changedPatternCallback, final TriConsumer<URI, String, Integer> selectedTypeCallback) {
        this.api = api;
        SwingUtil.invokeLater(() -> {
            this.searchInConstantPoolsDialog = new JDialog(mainFrame, "Search", false);
            JPanel panel = new JPanel();
            panel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
            panel.setLayout(new BorderLayout());
            this.searchInConstantPoolsDialog.add(panel);
            Box vbox = Box.createVerticalBox();
            Box hbox = Box.createHorizontalBox();
            hbox.add(new JLabel("Search string (* = any string, ? = any character):"));
            hbox.add(Box.createHorizontalGlue());
            vbox.add(hbox);
            vbox.add(Box.createVerticalStrut(10));
            this.searchInConstantPoolsEnterTextField = new JTextField(30);
            vbox.add(this.searchInConstantPoolsEnterTextField);
            this.searchInConstantPoolsEnterTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    if (e.getKeyChar() == '=' || e.getKeyChar() == '(' || e.getKeyChar() == ')' || e.getKeyChar() == '{' || e.getKeyChar() == '}' || e.getKeyChar() == '[' || e.getKeyChar() == ']' || Character.isDigit(e.getKeyChar()) && SearchInConstantPoolsView.this.searchInConstantPoolsEnterTextField.getText().isEmpty()) {
                        e.consume();
                    }
                }

                @Override
                public void keyPressed(KeyEvent e) {
                    DefaultMutableTreeNode root;
                    if (e.getKeyCode() == 40 && (root = (DefaultMutableTreeNode)SearchInConstantPoolsView.this.searchInConstantPoolsTree.getModel().getRoot()).getChildCount() > 0) {
                        SearchInConstantPoolsView.this.searchInConstantPoolsTree.requestFocus();
                        if (SearchInConstantPoolsView.this.searchInConstantPoolsTree.getSelectionCount() == 0) {
                            SearchInConstantPoolsView.this.searchInConstantPoolsTree.setSelectionPath(new TreePath(((DefaultMutableTreeNode)root.getChildAt(0)).getPath()));
                        }
                        e.consume();
                    }
                }
            });
            this.searchInConstantPoolsEnterTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.call();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.call();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.call();
                }

                protected void call() {
                    changedPatternCallback.accept(SearchInConstantPoolsView.this.searchInConstantPoolsEnterTextField.getText(), SearchInConstantPoolsView.this.getFlags());
                }
            });
            vbox.add(Box.createVerticalStrut(10));
            hbox = Box.createHorizontalBox();
            vbox.add(hbox);
            JPanel subpanel = new JPanel();
            subpanel.setBorder(BorderFactory.createTitledBorder("Search For"));
            subpanel.setLayout(new BorderLayout());
            hbox.add(subpanel);
            Box subhbox = Box.createHorizontalBox();
            subpanel.add((Component)subhbox, "West");
            ItemListener checkBoxListener = e -> {
                changedPatternCallback.accept(this.searchInConstantPoolsEnterTextField.getText(), this.getFlags());
                this.searchInConstantPoolsEnterTextField.requestFocus();
            };
            JPanel subsubpanel = new JPanel();
            subsubpanel.setLayout(new GridLayout(2, 1));
            this.searchInConstantPoolsCheckBoxType = new JCheckBox("Type", true);
            subsubpanel.add(this.searchInConstantPoolsCheckBoxType);
            this.searchInConstantPoolsCheckBoxType.addItemListener(checkBoxListener);
            this.searchInConstantPoolsCheckBoxField = new JCheckBox("Field");
            subsubpanel.add(this.searchInConstantPoolsCheckBoxField);
            this.searchInConstantPoolsCheckBoxField.addItemListener(checkBoxListener);
            subhbox.add(subsubpanel);
            subsubpanel = new JPanel();
            subsubpanel.setLayout(new GridLayout(2, 1));
            this.searchInConstantPoolsCheckBoxConstructor = new JCheckBox("Constructor");
            subsubpanel.add(this.searchInConstantPoolsCheckBoxConstructor);
            this.searchInConstantPoolsCheckBoxConstructor.addItemListener(checkBoxListener);
            this.searchInConstantPoolsCheckBoxMethod = new JCheckBox("Method");
            subsubpanel.add(this.searchInConstantPoolsCheckBoxMethod);
            this.searchInConstantPoolsCheckBoxMethod.addItemListener(checkBoxListener);
            subhbox.add(subsubpanel);
            subsubpanel = new JPanel();
            subsubpanel.setLayout(new GridLayout(2, 1));
            this.searchInConstantPoolsCheckBoxString = new JCheckBox("String Constant");
            subsubpanel.add(this.searchInConstantPoolsCheckBoxString);
            this.searchInConstantPoolsCheckBoxString.addItemListener(checkBoxListener);
            this.searchInConstantPoolsCheckBoxModule = new JCheckBox("Java Module");
            subsubpanel.add(this.searchInConstantPoolsCheckBoxModule);
            this.searchInConstantPoolsCheckBoxModule.addItemListener(checkBoxListener);
            subhbox.add(subsubpanel);
            subpanel = new JPanel();
            subpanel.setBorder(BorderFactory.createTitledBorder("Limit To"));
            subpanel.setLayout(new BorderLayout());
            hbox.add(subpanel);
            subhbox = Box.createHorizontalBox();
            subpanel.add((Component)subhbox, "West");
            subsubpanel = new JPanel();
            subsubpanel.setLayout(new GridLayout(2, 1));
            this.searchInConstantPoolsCheckBoxDeclarations = new JCheckBox("Declarations", true);
            subsubpanel.add(this.searchInConstantPoolsCheckBoxDeclarations);
            this.searchInConstantPoolsCheckBoxDeclarations.addItemListener(checkBoxListener);
            this.searchInConstantPoolsCheckBoxReferences = new JCheckBox("References", true);
            subsubpanel.add(this.searchInConstantPoolsCheckBoxReferences);
            this.searchInConstantPoolsCheckBoxReferences.addItemListener(checkBoxListener);
            subhbox.add(subsubpanel);
            vbox.add(Box.createVerticalStrut(10));
            hbox = Box.createHorizontalBox();
            this.searchInConstantPoolsLabel = new JLabel("Matching types:");
            hbox.add(this.searchInConstantPoolsLabel);
            hbox.add(Box.createHorizontalGlue());
            vbox.add(hbox);
            vbox.add(Box.createVerticalStrut(10));
            panel.add((Component)vbox, "North");
            this.searchInConstantPoolsTree = new Tree();
            JScrollPane scrollPane = new JScrollPane(this.searchInConstantPoolsTree);
            this.searchInConstantPoolsTree.setShowsRootHandles(true);
            this.searchInConstantPoolsTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
            this.searchInConstantPoolsTree.setCellRenderer(new TreeNodeRenderer());
            this.searchInConstantPoolsTree.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 38 && SearchInConstantPoolsView.this.searchInConstantPoolsTree.getLeadSelectionRow() == 0) {
                        SearchInConstantPoolsView.this.searchInConstantPoolsEnterTextField.requestFocus();
                        e.consume();
                    }
                }
            });
            this.searchInConstantPoolsTree.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    DefaultMutableTreeNode node;
                    if (e.getClickCount() == 2 && (node = (DefaultMutableTreeNode)SearchInConstantPoolsView.this.searchInConstantPoolsTree.getLastSelectedPathComponent()) != null) {
                        selectedTypeCallback.accept(((UriGettable)((Object)node)).getUri(), SearchInConstantPoolsView.this.searchInConstantPoolsEnterTextField.getText(), SearchInConstantPoolsView.this.getFlags());
                    }
                }
            });
            this.searchInConstantPoolsTree.addTreeExpansionListener(new TreeExpansionListener(){

                @Override
                public void treeExpanded(TreeExpansionEvent e) {
                    DefaultTreeModel model = (DefaultTreeModel)SearchInConstantPoolsView.this.searchInConstantPoolsTree.getModel();
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
                    while (true) {
                        SearchInConstantPoolsView.this.populate(model, node);
                        if (node.getChildCount() == 0) break;
                        node = (DefaultMutableTreeNode)node.getChildAt(0);
                    }
                    SearchInConstantPoolsView.this.searchInConstantPoolsTree.setSelectionPath(new TreePath(node.getPath()));
                }

                @Override
                public void treeCollapsed(TreeExpansionEvent e) {
                }
            });
            scrollPane.setHorizontalScrollBarPolicy(31);
            scrollPane.setPreferredSize(new Dimension(400, 150));
            panel.add((Component)scrollPane, "Center");
            vbox = Box.createVerticalBox();
            vbox.add(Box.createVerticalStrut(25));
            hbox = Box.createHorizontalBox();
            hbox.add(Box.createHorizontalGlue());
            final JButton searchInConstantPoolsOpenButton = new JButton("Open");
            hbox.add(searchInConstantPoolsOpenButton);
            searchInConstantPoolsOpenButton.setEnabled(false);
            AbstractAction searchInConstantPoolsOpenActionListener = new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DefaultMutableTreeNode selectedTreeNode = (DefaultMutableTreeNode)SearchInConstantPoolsView.this.searchInConstantPoolsTree.getLastSelectedPathComponent();
                    if (selectedTreeNode != null) {
                        selectedTypeCallback.accept(((UriGettable)((Object)selectedTreeNode)).getUri(), SearchInConstantPoolsView.this.searchInConstantPoolsEnterTextField.getText(), SearchInConstantPoolsView.this.getFlags());
                    }
                }
            };
            searchInConstantPoolsOpenButton.addActionListener(searchInConstantPoolsOpenActionListener);
            hbox.add(Box.createHorizontalStrut(5));
            JButton searchInConstantPoolsCancelButton = new JButton("Cancel");
            hbox.add(searchInConstantPoolsCancelButton);
            AbstractAction searchInConstantPoolsCancelActionListener = new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SearchInConstantPoolsView.this.searchInConstantPoolsDialog.setVisible(false);
                }
            };
            searchInConstantPoolsCancelButton.addActionListener(searchInConstantPoolsCancelActionListener);
            vbox.add(hbox);
            panel.add((Component)vbox, "South");
            JRootPane rootPane = this.searchInConstantPoolsDialog.getRootPane();
            rootPane.setDefaultButton(searchInConstantPoolsOpenButton);
            rootPane.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "SearchInConstantPoolsView.cancel");
            rootPane.getActionMap().put("SearchInConstantPoolsView.cancel", searchInConstantPoolsCancelActionListener);
            this.searchInConstantPoolsDialog.setMinimumSize(this.searchInConstantPoolsDialog.getSize());
            this.searchInConstantPoolsEnterTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    SearchInConstantPoolsView.this.searchInConstantPoolsTree.clearSelection();
                    searchInConstantPoolsOpenButton.setEnabled(false);
                }
            });
            this.searchInConstantPoolsTree.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    searchInConstantPoolsOpenButton.setEnabled(SearchInConstantPoolsView.this.searchInConstantPoolsTree.getSelectionCount() > 0);
                }
            });
            this.searchInConstantPoolsDialog.pack();
            this.searchInConstantPoolsDialog.setLocationRelativeTo(this.searchInConstantPoolsDialog.getParent());
        });
    }

    protected void populate(DefaultTreeModel model, T node) {
        this.populate(node);
        int i = ((DefaultMutableTreeNode)node).getChildCount();
        while (i-- > 0) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)((DefaultMutableTreeNode)node).getChildAt(i);
            if (!(child instanceof TreeNodeExpandable) || this.expanded.contains(((UriGettable)((Object)child)).getUri())) continue;
            this.populate(child);
        }
        model.reload((TreeNode)node);
    }

    protected void populate(T node) {
        if (node instanceof TreeNodeExpandable && !this.expanded.contains(((UriGettable)node).getUri())) {
            ((TreeNodeExpandable)node).populateTreeNode(this.api);
            this.expanded.add(((UriGettable)node).getUri());
            int i = ((DefaultMutableTreeNode)node).getChildCount();
            while (i-- > 0) {
                if (this.accepted.contains(((UriGettable)((Object)((DefaultMutableTreeNode)((DefaultMutableTreeNode)node).getChildAt(i)))).getUri())) continue;
                ((DefaultMutableTreeNode)node).remove(i);
            }
        }
    }

    public void show() {
        SwingUtil.invokeLater(() -> {
            this.searchInConstantPoolsEnterTextField.selectAll();
            this.searchInConstantPoolsDialog.setVisible(true);
            this.searchInConstantPoolsEnterTextField.requestFocus();
        });
    }

    public boolean isVisible() {
        return this.searchInConstantPoolsDialog.isVisible();
    }

    public String getPattern() {
        return this.searchInConstantPoolsEnterTextField.getText();
    }

    public int getFlags() {
        int flags = 0;
        if (this.searchInConstantPoolsCheckBoxType.isSelected()) {
            ++flags;
        }
        if (this.searchInConstantPoolsCheckBoxConstructor.isSelected()) {
            flags += 2;
        }
        if (this.searchInConstantPoolsCheckBoxMethod.isSelected()) {
            flags += 4;
        }
        if (this.searchInConstantPoolsCheckBoxField.isSelected()) {
            flags += 8;
        }
        if (this.searchInConstantPoolsCheckBoxString.isSelected()) {
            flags += 16;
        }
        if (this.searchInConstantPoolsCheckBoxModule.isSelected()) {
            flags += 32;
        }
        if (this.searchInConstantPoolsCheckBoxDeclarations.isSelected()) {
            flags += 64;
        }
        if (this.searchInConstantPoolsCheckBoxReferences.isSelected()) {
            flags += 128;
        }
        return flags;
    }

    public void showWaitCursor() {
        SwingUtil.invokeLater(() -> this.searchInConstantPoolsDialog.setCursor(Cursor.getPredefinedCursor(3)));
    }

    public void hideWaitCursor() {
        SwingUtil.invokeLater(() -> this.searchInConstantPoolsDialog.setCursor(Cursor.getDefaultCursor()));
    }

    public void updateTree(Collection<DelegatingFilterContainer> containers, int matchingTypeCount) {
        SwingUtil.invokeLater(() -> {
            DefaultTreeModel model = (DefaultTreeModel)this.searchInConstantPoolsTree.getModel();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
            root.removeAllChildren();
            this.accepted.clear();
            this.expanded.clear();
            if (containers != null) {
                ArrayList<DelegatingFilterContainer> list = new ArrayList<DelegatingFilterContainer>(containers);
                list.sort(Comparator.comparing(Container::getRootUri));
                for (DelegatingFilterContainer container : list) {
                    this.accepted.addAll(container.getUris());
                    Container.Entry parentEntry = container.getRoot().getParent();
                    TreeNodeFactory treeNodeFactory = this.api.getTreeNodeFactory(parentEntry);
                    if (treeNodeFactory == null) continue;
                    root.add((MutableTreeNode)treeNodeFactory.make(this.api, parentEntry));
                }
                DefaultMutableTreeNode node = root;
                while (true) {
                    this.populate(model, node);
                    if (node.getChildCount() == 0) break;
                    node = (DefaultMutableTreeNode)node.getChildAt(0);
                }
                this.searchInConstantPoolsTree.setSelectionPath(new TreePath(node.getPath()));
            } else {
                model.reload();
            }
            switch (matchingTypeCount) {
                case 0: {
                    this.searchInConstantPoolsLabel.setText("Matching entries:");
                    break;
                }
                case 1: {
                    this.searchInConstantPoolsLabel.setText("1 matching entry:");
                    break;
                }
                default: {
                    this.searchInConstantPoolsLabel.setText(matchingTypeCount + " matching entries:");
                }
            }
        });
    }
}

