/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jd.gui.model.configuration.Configuration;
import org.jd.gui.spi.PreferencesPanel;
import org.jd.gui.util.swing.SwingUtil;

public class PreferencesView
implements PreferencesPanel.PreferencesPanelChangeListener {
    private final Map<String, String> preferences;
    private final Collection<PreferencesPanel> panels;
    private final Map<PreferencesPanel, Boolean> valids = new HashMap<PreferencesPanel, Boolean>();
    private JDialog preferencesDialog;
    private final JButton preferencesOkButton = new JButton();
    private Runnable okCallback;

    public PreferencesView(Configuration configuration, JFrame mainFrame, Collection<PreferencesPanel> panels) {
        this.preferences = configuration.getPreferences();
        this.panels = panels;
        SwingUtil.invokeLater(() -> {
            this.preferencesDialog = new JDialog(mainFrame, "Preferences", false);
            JPanel panel = new JPanel();
            panel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
            panel.setLayout(new BorderLayout());
            this.preferencesDialog.add(panel);
            Box preferencesPanels = Box.createVerticalBox();
            preferencesPanels.setBackground(panel.getBackground());
            preferencesPanels.setOpaque(true);
            Color errorBackgroundColor = Color.decode(configuration.getPreferences().get("JdGuiPreferences.errorBackgroundColor"));
            HashMap<String, ArrayList<PreferencesPanel>> groups = new HashMap<String, ArrayList<PreferencesPanel>>();
            ArrayList<String> sortedGroupNames = new ArrayList<String>();
            for (PreferencesPanel pp : panels) {
                ArrayList<PreferencesPanel> pps = (ArrayList<PreferencesPanel>)groups.get(pp.getPreferencesGroupTitle());
                pp.init(errorBackgroundColor);
                pp.addPreferencesChangeListener(this);
                if (pps == null) {
                    String groupNames = pp.getPreferencesGroupTitle();
                    pps = new ArrayList<PreferencesPanel>();
                    groups.put(groupNames, pps);
                    sortedGroupNames.add(groupNames);
                }
                pps.add(pp);
            }
            Collections.sort(sortedGroupNames);
            for (String groupName : sortedGroupNames) {
                Box vbox = Box.createVerticalBox();
                vbox.setBorder(BorderFactory.createTitledBorder(groupName));
                List sortedPreferencesPanels = (List)groups.get(groupName);
                Collections.sort(sortedPreferencesPanels, Comparator.comparing(PreferencesPanel::getPreferencesPanelTitle));
                for (PreferencesPanel pp : sortedPreferencesPanels) {
                    Box hbox = Box.createHorizontalBox();
                    JLabel title = new JLabel(pp.getPreferencesPanelTitle());
                    title.setFont(title.getFont().deriveFont(1));
                    hbox.add(title);
                    hbox.add(Box.createHorizontalGlue());
                    hbox.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
                    vbox.add(hbox);
                    JComponent component = pp.getPanel();
                    component.setMaximumSize(new Dimension(component.getMaximumSize().width, component.getPreferredSize().height));
                    vbox.add(component);
                }
                preferencesPanels.add(vbox);
            }
            JScrollPane preferencesScrollPane = new JScrollPane(preferencesPanels);
            preferencesScrollPane.setHorizontalScrollBarPolicy(31);
            preferencesScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            panel.add((Component)preferencesScrollPane, "Center");
            Box vbox = Box.createVerticalBox();
            panel.add((Component)vbox, "South");
            vbox.add(Box.createVerticalStrut(15));
            Box hbox = Box.createHorizontalBox();
            hbox.add(Box.createHorizontalGlue());
            this.preferencesOkButton.setText("   Ok   ");
            this.preferencesOkButton.addActionListener(e -> {
                for (PreferencesPanel pp : panels) {
                    pp.savePreferences(this.preferences);
                }
                this.preferencesDialog.setVisible(false);
                this.okCallback.run();
            });
            hbox.add(this.preferencesOkButton);
            hbox.add(Box.createHorizontalStrut(5));
            JButton preferencesCancelButton = new JButton("Cancel");
            AbstractAction preferencesCancelActionListener = new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PreferencesView.this.preferencesDialog.setVisible(false);
                }
            };
            preferencesCancelButton.addActionListener(preferencesCancelActionListener);
            hbox.add(preferencesCancelButton);
            vbox.add(hbox);
            JRootPane rootPane = this.preferencesDialog.getRootPane();
            rootPane.setDefaultButton(this.preferencesOkButton);
            rootPane.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "PreferencesDescription.cancel");
            rootPane.getActionMap().put("PreferencesDescription.cancel", preferencesCancelActionListener);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Insets scnMax = Toolkit.getDefaultToolkit().getScreenInsets(this.preferencesDialog.getGraphicsConfiguration());
            int taskBarHeight = scnMax.bottom + scnMax.top;
            int maxHeight = screenSize.height - taskBarHeight;
            int preferredHeight = preferencesPanels.getPreferredSize().height + 2;
            if (preferredHeight > maxHeight) {
                preferredHeight = maxHeight;
            }
            preferencesScrollPane.setPreferredSize(new Dimension(400, preferredHeight));
            this.preferencesDialog.setMinimumSize(new Dimension(300, 200));
            this.preferencesDialog.pack();
            this.preferencesDialog.setLocationRelativeTo(mainFrame);
        });
    }

    public void show(Runnable okCallback) {
        this.okCallback = okCallback;
        SwingUtilities.invokeLater(() -> {
            for (PreferencesPanel pp : this.panels) {
                pp.loadPreferences(this.preferences);
            }
            this.preferencesDialog.setVisible(true);
        });
    }

    @Override
    public void preferencesPanelChanged(PreferencesPanel source) {
        SwingUtil.invokeLater(() -> {
            boolean valid = source.arePreferencesValid();
            this.valids.put(source, valid);
            if (valid) {
                for (PreferencesPanel pp : this.panels) {
                    if (this.valids.get(pp) != Boolean.FALSE) continue;
                    this.preferencesOkButton.setEnabled(false);
                    return;
                }
                this.preferencesOkButton.setEnabled(true);
            } else {
                this.preferencesOkButton.setEnabled(false);
            }
        });
    }
}

