/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.function.IntConsumer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jd.gui.api.feature.LineNumberNavigable;
import org.jd.gui.model.configuration.Configuration;
import org.jd.gui.util.swing.SwingUtil;

public class GoToView {
    private JDialog goToDialog;
    private JLabel goToEnterLineNumberLabel;
    private JTextField goToEnterLineNumberTextField;
    private JLabel goToEnterLineNumberErrorLabel;
    private LineNumberNavigable navigator;
    private IntConsumer okCallback;

    public GoToView(final Configuration configuration, JFrame mainFrame) {
        SwingUtil.invokeLater(() -> {
            this.goToDialog = new JDialog(mainFrame, "Go to Line", false);
            this.goToDialog.setResizable(false);
            Box vbox = Box.createVerticalBox();
            vbox.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
            this.goToDialog.add(vbox);
            Box hbox = Box.createHorizontalBox();
            this.goToEnterLineNumberLabel = new JLabel();
            hbox.add(this.goToEnterLineNumberLabel);
            hbox.add(Box.createHorizontalGlue());
            vbox.add(hbox);
            vbox.add(Box.createVerticalStrut(10));
            this.goToEnterLineNumberTextField = new JTextField(30);
            vbox.add(this.goToEnterLineNumberTextField);
            vbox.add(Box.createVerticalStrut(10));
            hbox = Box.createHorizontalBox();
            this.goToEnterLineNumberErrorLabel = new JLabel(" ");
            hbox.add(this.goToEnterLineNumberErrorLabel);
            this.goToEnterLineNumberTextField.addKeyListener(new KeyAdapter(this){

                @Override
                public void keyTyped(KeyEvent e) {
                    if (!Character.isDigit(e.getKeyChar())) {
                        e.consume();
                    }
                }
            });
            hbox.add(Box.createHorizontalGlue());
            vbox.add(hbox);
            vbox.add(Box.createVerticalStrut(15));
            hbox = Box.createHorizontalBox();
            hbox.add(Box.createHorizontalGlue());
            final JButton goToOkButton = new JButton("   Ok   ");
            hbox.add(goToOkButton);
            goToOkButton.setEnabled(false);
            goToOkButton.addActionListener(e -> {
                this.okCallback.accept(Integer.parseInt(this.goToEnterLineNumberTextField.getText()));
                this.goToDialog.setVisible(false);
            });
            hbox.add(Box.createHorizontalStrut(5));
            JButton goToCancelButton = new JButton("Cancel");
            hbox.add(goToCancelButton);
            AbstractAction goToCancelActionListener = new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GoToView.this.goToDialog.setVisible(false);
                }
            };
            goToCancelButton.addActionListener(goToCancelActionListener);
            vbox.add(hbox);
            vbox.add(Box.createVerticalStrut(13));
            JRootPane rootPane = this.goToDialog.getRootPane();
            rootPane.setDefaultButton(goToOkButton);
            rootPane.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "OpenTypeView.cancel");
            rootPane.getActionMap().put("OpenTypeView.cancel", goToCancelActionListener);
            this.goToEnterLineNumberTextField.getDocument().addDocumentListener(new DocumentListener(){
                protected Color backgroundColor = UIManager.getColor("TextField.background");
                protected Color errorBackgroundColor = Color.decode(configuration.getPreferences().get("JdGuiPreferences.errorBackgroundColor"));

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.onTextChange();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.onTextChange();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.onTextChange();
                }

                protected void onTextChange() {
                    String text = GoToView.this.goToEnterLineNumberTextField.getText();
                    if (text.isEmpty()) {
                        goToOkButton.setEnabled(false);
                        this.clearErrorMessage();
                    } else {
                        try {
                            int lineNumber = Integer.parseInt(text);
                            if (lineNumber > GoToView.this.navigator.getMaximumLineNumber()) {
                                goToOkButton.setEnabled(false);
                                this.showErrorMessage("Line number out of range");
                            } else if (GoToView.this.navigator.checkLineNumber(lineNumber)) {
                                goToOkButton.setEnabled(true);
                                this.clearErrorMessage();
                            } else {
                                goToOkButton.setEnabled(false);
                                this.showErrorMessage("Line number not found");
                            }
                        }
                        catch (NumberFormatException e) {
                            goToOkButton.setEnabled(false);
                            this.showErrorMessage("Not a number");
                        }
                    }
                }

                protected void showErrorMessage(String message) {
                    GoToView.this.goToEnterLineNumberErrorLabel.setText(message);
                    GoToView.this.goToEnterLineNumberTextField.setBackground(this.errorBackgroundColor);
                }

                protected void clearErrorMessage() {
                    GoToView.this.goToEnterLineNumberErrorLabel.setText(" ");
                    GoToView.this.goToEnterLineNumberTextField.setBackground(this.backgroundColor);
                }
            });
            this.goToDialog.pack();
            this.goToDialog.setLocationRelativeTo(mainFrame);
        });
    }

    public void show(LineNumberNavigable navigator, IntConsumer okCallback) {
        this.navigator = navigator;
        this.okCallback = okCallback;
        SwingUtil.invokeLater(() -> {
            this.goToEnterLineNumberLabel.setText("Enter line number (1.." + navigator.getMaximumLineNumber() + "):");
            this.goToEnterLineNumberTextField.setText("");
            this.goToDialog.setVisible(true);
            this.goToEnterLineNumberTextField.requestFocus();
        });
    }
}

