/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.util.xml;

import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;

public abstract class AbstractXmlPathFinder {
    private final Map<String, Set<String>> tagNameToPaths = new HashMap<String, Set<String>>();
    private final StringBuilder sb = new StringBuilder(200);

    protected AbstractXmlPathFinder(Collection<String> paths) {
        for (String string : paths) {
            if (string == null || string.isEmpty()) continue;
            String string2 = "/" + string;
            int lastIndex = string2.lastIndexOf(47);
            String lastTagName = string2.substring(lastIndex + 1);
            this.tagNameToPaths.computeIfAbsent(lastTagName, k -> new HashSet()).add(string2);
        }
    }

    public void find(String text) {
        block9: {
            this.sb.setLength(0);
            try {
                XMLInputFactory factory = XMLInputFactory.newInstance();
                factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                XMLStreamReader reader = factory.createXMLStreamReader(new StringReader(text));
                String tagName = "";
                int offset = 0;
                while (reader.hasNext()) {
                    reader.next();
                    switch (reader.getEventType()) {
                        case 1: {
                            tagName = reader.getLocalName();
                            this.sb.append('/').append(tagName);
                            offset = reader.getLocation().getCharacterOffset();
                            break;
                        }
                        case 2: {
                            this.sb.setLength(this.sb.length() - reader.getLocalName().length() - 1);
                            break;
                        }
                        case 4: {
                            String path;
                            Set<String> setOfPaths = this.tagNameToPaths.get(tagName);
                            if (setOfPaths == null || !setOfPaths.contains(path = this.sb.toString())) break;
                            while (offset > 0 && text.charAt(offset) != '>') {
                                --offset;
                            }
                            this.handle(path.substring(1), reader.getText(), offset + 1);
                        }
                    }
                }
            }
            catch (XMLStreamException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block9;
                throw new AssertionError();
            }
        }
    }

    public abstract void handle(String var1, String var2, int var3);
}

