/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.util.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public final class SwingUtil {
    private SwingUtil() {
    }

    public static void invokeLater(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static Action newAction(String name, boolean enable, final ActionListener listener) {
        AbstractAction action = new AbstractAction(name){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                listener.actionPerformed(actionEvent);
            }
        };
        action.setEnabled(enable);
        return action;
    }

    public static Action newAction(String name, ImageIcon icon, boolean enable, ActionListener listener) {
        Action action = SwingUtil.newAction(name, enable, listener);
        action.putValue("SmallIcon", icon);
        return action;
    }

    public static Action newAction(ImageIcon icon, boolean enable, ActionListener listener) {
        Action action = SwingUtil.newAction(null, icon, enable, listener);
        action.putValue("SmallIcon", icon);
        return action;
    }

    public static Action newAction(String name, ImageIcon icon, boolean enable, String shortDescription, ActionListener listener) {
        Action action = SwingUtil.newAction(name, icon, enable, listener);
        action.putValue("ShortDescription", shortDescription);
        return action;
    }

    public static Action newAction(String name, boolean enable, String shortDescription, ActionListener listener) {
        Action action = SwingUtil.newAction(name, enable, listener);
        action.putValue("ShortDescription", shortDescription);
        return action;
    }
}

