/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.util.swing;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;

public abstract class AbstractSwingWorker<T, V>
extends SwingWorker<T, V> {
    private final ProgressMonitor progressMonitor;
    private double progressPercentage;

    protected AbstractSwingWorker(Component component, String message) {
        this.progressMonitor = new ProgressMonitor(component, message, AbstractSwingWorker.getProgressMessage(0), 0, 100);
        this.addPropertyChangeListener(e -> this.onPropertyChange(e, this.progressMonitor));
    }

    private void onPropertyChange(PropertyChangeEvent evt, ProgressMonitor progressMonitor) {
        if ("progress".equals(evt.getPropertyName())) {
            int progress = (Integer)evt.getNewValue();
            progressMonitor.setProgress(progress);
            String message = AbstractSwingWorker.getProgressMessage(progress);
            progressMonitor.setNote(message);
            if (progressMonitor.isCanceled()) {
                this.cancel(true);
            }
        }
    }

    @Override
    protected void done() {
        this.progressMonitor.close();
    }

    private static String getProgressMessage(int progress) {
        return String.format("Completed %d%%.%n", progress);
    }

    public double getProgressPercentage() {
        return this.progressPercentage;
    }

    public void setProgressPercentage(double progressPercentage) {
        super.setProgress((int)Math.round(progressPercentage));
        this.progressPercentage = progressPercentage;
    }
}

