/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.util.parser.jdt.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.jd.gui.api.model.Container;

public abstract class AbstractJavaListener
extends ASTVisitor {
    protected final Container.Entry entry;
    protected String packageName = "";
    protected final Map<String, String> nameToInternalTypeName = new HashMap<String, String>();
    private final Map<String, String> typeNameCache = new HashMap<String, String>();

    protected AbstractJavaListener(Container.Entry entry) {
        this.entry = entry;
    }

    protected static String nameToString(Name name) {
        if (name instanceof SimpleName) {
            SimpleName simpleName = (SimpleName)name;
            return simpleName.getIdentifier();
        }
        if (name instanceof QualifiedName) {
            QualifiedName qualifiedName = (QualifiedName)name;
            Name qualifier = qualifiedName.getQualifier();
            String identifier = qualifiedName.getName().getIdentifier();
            return String.join((CharSequence)"/", AbstractJavaListener.nameToString(qualifier), identifier);
        }
        throw new UnsupportedOperationException();
    }

    public boolean visit(PackageDeclaration node) {
        this.packageName = AbstractJavaListener.nameToString(node.getName());
        return true;
    }

    public boolean visit(ImportDeclaration node) {
        Name name = node.getName();
        if (name instanceof QualifiedName) {
            QualifiedName qualifiedName = (QualifiedName)name;
            String simpleName = qualifiedName.getName().getIdentifier();
            String internalTypeName = AbstractJavaListener.nameToString(name);
            this.nameToInternalTypeName.put(simpleName, internalTypeName);
        }
        return true;
    }

    protected abstract boolean enterTypeDeclaration(AbstractTypeDeclaration var1, int var2);

    protected abstract void exitTypeDeclaration();

    public boolean visit(TypeDeclaration node) {
        return this.enterTypeDeclaration((AbstractTypeDeclaration)node, node.isInterface() ? 512 : 0);
    }

    public boolean visit(EnumDeclaration node) {
        return this.enterTypeDeclaration((AbstractTypeDeclaration)node, 16384);
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        return this.enterTypeDeclaration((AbstractTypeDeclaration)node, 8192);
    }

    public void endVisit(TypeDeclaration node) {
        this.exitTypeDeclaration();
    }

    public void endVisit(EnumDeclaration node) {
        this.exitTypeDeclaration();
    }

    public void endVisit(AnnotationTypeDeclaration node) {
        this.exitTypeDeclaration();
    }

    protected static String typeToString(Type type) {
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            return AbstractJavaListener.typeToString(arrayType.getElementType());
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return AbstractJavaListener.typeToString(parameterizedType.getType());
        }
        if (type instanceof QualifiedType) {
            QualifiedType qualifiedType = (QualifiedType)type;
            Type qualifierType = qualifiedType.getQualifier();
            String qualifiedIdentifier = qualifiedType.getName().getIdentifier();
            return String.join((CharSequence)"/", AbstractJavaListener.typeToString(qualifierType), qualifiedIdentifier);
        }
        if (type instanceof SimpleType) {
            SimpleType simpleType = (SimpleType)type;
            return AbstractJavaListener.nameToString(simpleType.getName());
        }
        if (type instanceof NameQualifiedType) {
            NameQualifiedType nameQualifiedType = (NameQualifiedType)type;
            String qualifiedIdentifier = nameQualifiedType.getName().getIdentifier();
            return String.join((CharSequence)"/", AbstractJavaListener.nameToString(nameQualifiedType.getQualifier()), qualifiedIdentifier);
        }
        throw new UnsupportedOperationException();
    }

    protected String resolveInternalTypeName(Type type) {
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            return this.resolveInternalTypeName(arrayType.getElementType());
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return this.resolveInternalTypeName(parameterizedType.getType());
        }
        if (type instanceof QualifiedType) {
            QualifiedType qualifiedType = (QualifiedType)type;
            Type qualifierType = qualifiedType.getQualifier();
            String qualifiedIdentifier = qualifiedType.getName().getIdentifier();
            return String.join((CharSequence)"/", this.resolveInternalTypeName(qualifierType), qualifiedIdentifier);
        }
        if (type instanceof NameQualifiedType) {
            NameQualifiedType nameQualifiedType = (NameQualifiedType)type;
            return AbstractJavaListener.nameToString((Name)nameQualifiedType.getName());
        }
        if (type instanceof SimpleType) {
            SimpleType simpleType = (SimpleType)type;
            Name simpleTypeName = simpleType.getName();
            if (simpleTypeName instanceof SimpleName) {
                SimpleName simpleName = (SimpleName)simpleTypeName;
                String name = simpleName.getIdentifier();
                Object qualifiedName = this.typeNameCache.get(name);
                if (qualifiedName != null) {
                    return qualifiedName;
                }
                String imp = this.nameToInternalTypeName.get(name);
                if (imp != null) {
                    return imp;
                }
                String prefix = name + ".";
                if (this.entry.getPath().indexOf(47) != -1) {
                    Container.Entry parent = this.entry.getParent();
                    int packageLength = parent.getPath().length() + 1;
                    for (Container.Entry child : parent.getChildren().values()) {
                        if (child.isDirectory() || !child.getPath().startsWith(prefix, packageLength)) continue;
                        qualifiedName = this.packageName + "/" + name;
                        this.typeNameCache.put(name, (String)qualifiedName);
                        return qualifiedName;
                    }
                }
                for (Container.Entry child : this.entry.getContainer().getRoot().getChildren().values()) {
                    if (child.isDirectory() || !child.getPath().startsWith(prefix)) continue;
                    this.typeNameCache.put(name, name);
                    return name;
                }
                if (((Object)((Object)this)).getClass().getClassLoader().getResource("java/lang/" + name + ".class") != null) {
                    qualifiedName = "java/lang/" + name;
                    this.typeNameCache.put(name, (String)qualifiedName);
                    return qualifiedName;
                }
                qualifiedName = "*/" + name;
                this.typeNameCache.put(name, (String)qualifiedName);
                return qualifiedName;
            }
            return AbstractJavaListener.nameToString(simpleTypeName);
        }
        return "java/lang/Object";
    }

    public PrimitiveType getPrimitiveTypeContext(Type type) {
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            return this.getPrimitiveTypeContext(arrayType.getElementType());
        }
        if (type instanceof PrimitiveType) {
            return (PrimitiveType)type;
        }
        return null;
    }

    protected String createDescriptor(Type type, int dimension) {
        if (type == null) {
            return "V";
        }
        dimension += this.countDimension(type);
        Object name = null;
        PrimitiveType primitive = this.getPrimitiveTypeContext(type);
        if (primitive == null) {
            name = "L" + this.resolveInternalTypeName(type) + ";";
        } else {
            name = switch (primitive.getPrimitiveTypeCode().toString()) {
                case "boolean" -> "Z";
                case "byte" -> "B";
                case "char" -> "C";
                case "double" -> "D";
                case "float" -> "F";
                case "int" -> "I";
                case "long" -> "J";
                case "short" -> "S";
                case "void" -> "V";
                default -> throw new IllegalStateException("UNEXPECTED PRIMITIVE");
            };
        }
        return switch (dimension) {
            case 0 -> name;
            case 1 -> "[" + (String)name;
            case 2 -> "[[" + (String)name;
            default -> new String(new char[dimension]).replace('\u0000', '[') + (String)name;
        };
    }

    protected String createParamDescriptors(List<SingleVariableDeclaration> formalParameterList) {
        StringBuilder paramDescriptors = null;
        if (formalParameterList != null) {
            paramDescriptors = new StringBuilder("(");
            for (SingleVariableDeclaration formalParameter : formalParameterList) {
                int dimensionOnParameter = formalParameter.getExtraDimensions();
                paramDescriptors.append(this.createDescriptor(formalParameter.getType(), dimensionOnParameter));
            }
        }
        return paramDescriptors == null ? "()" : paramDescriptors.append(')').toString();
    }

    protected int countDimension(Type type) {
        return type instanceof ArrayType ? ((ArrayType)type).getDimensions() : 0;
    }

    protected Type getSuperType(AbstractTypeDeclaration node) {
        TypeDeclaration td;
        Type superclassType;
        if (node instanceof TypeDeclaration && (superclassType = (td = (TypeDeclaration)node).getSuperclassType()) != null) {
            return superclassType;
        }
        return null;
    }
}

