/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.util.parser.jdt;

import java.net.URI;
import javax.swing.text.BadLocationException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.parser.AbstractParser;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParseResult;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParserNotice;
import org.fife.ui.rsyntaxtextarea.parser.ParseResult;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.util.parser.jdt.ASTParserFactory;

public class RSyntaxASTParser
extends AbstractParser {
    protected final API api;
    protected final Container.Entry entry;

    public RSyntaxASTParser(Container.Entry entry, API api) {
        this.api = api;
        this.entry = entry;
    }

    public ParseResult parse(RSyntaxDocument doc, String style) {
        DefaultParseResult result;
        block7: {
            boolean showErrors = "true".equals(this.api.getPreferences().get("ClassFileDecompilerPreferences.showCompilerErrors"));
            boolean showWarnings = "true".equals(this.api.getPreferences().get("ClassFileDecompilerPreferences.showCompilerWarnings"));
            boolean showInfo = "true".equals(this.api.getPreferences().get("ClassFileDecompilerPreferences.showCompilerInfo"));
            result = new DefaultParseResult((Parser)this);
            try {
                String text = doc.getText(0, doc.getLength());
                String unitName = this.entry.getPath();
                URI jarURI = this.entry.getContainer().getRoot().getParent().getUri();
                ASTNode ast = ASTParserFactory.getInstanceWithBindings().newASTParser(text.toCharArray(), unitName, jarURI).createAST(null);
                if (ast instanceof CompilationUnit) {
                    IProblem[] problems;
                    CompilationUnit cu = (CompilationUnit)ast;
                    for (IProblem pb : problems = cu.getProblems()) {
                        int sourceStart = pb.getSourceStart();
                        int length = pb.getSourceEnd() - sourceStart + 1;
                        String message = pb.getMessage();
                        int lineNo = pb.getSourceLineNumber();
                        DefaultParserNotice notice = new DefaultParserNotice((Parser)this, message, lineNo, sourceStart, length);
                        if (pb.isError()) {
                            notice.setLevel(ParserNotice.Level.ERROR);
                        }
                        if (pb.isWarning()) {
                            notice.setLevel(ParserNotice.Level.WARNING);
                        }
                        if (pb.isInfo()) {
                            notice.setLevel(ParserNotice.Level.INFO);
                        }
                        if (!(pb.isError() && showErrors || pb.isWarning() && showWarnings) && (!pb.isInfo() || !showInfo)) continue;
                        result.addNotice((ParserNotice)notice);
                    }
                }
            }
            catch (BadLocationException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block7;
                throw new AssertionError();
            }
        }
        return result;
    }
}

