/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.util.parser.jdt;

import com.heliosdecompiler.transformerapi.common.ClasspathUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.model.Container;
import org.jd.gui.util.decompiler.ContainerLoader;

public final class ASTParserFactory {
    private static final String DEFAULT_JDK_VERSION = "1.8";
    private static final ASTParserFactory INSTANCE = new ASTParserFactory(false, false, false);
    private static final ASTParserFactory BINDING_INSTANCE = new ASTParserFactory(true, true, true);
    private static final Map<URI, String> jarTojdkVersion = new ConcurrentHashMap<URI, String>();
    private final boolean resolveBindings;
    private final boolean bindingRecovery;
    private final boolean statementRecovery;

    private ASTParserFactory(boolean resolveBindings, boolean bindingRecovery, boolean statementRecovery) {
        this.resolveBindings = resolveBindings;
        this.bindingRecovery = bindingRecovery;
        this.statementRecovery = statementRecovery;
    }

    public static ASTParserFactory getInstance() {
        return INSTANCE;
    }

    public static ASTParserFactory getInstanceWithBindings() {
        return BINDING_INSTANCE;
    }

    public ASTParser newASTParser(Container.Entry entry) throws IOException {
        URI jarURI = entry.getContainer().getRoot().getParent().getUri();
        char[] source = ContainerLoader.loadEntry(entry, StandardCharsets.UTF_8);
        String unitName = entry.getPath();
        return this.newASTParser(source, unitName, jarURI);
    }

    public ASTParser newASTParser(char[] source, String unitName, URI jarURI) {
        ASTParser parser = ASTParser.newParser((int)AST.getJLSLatest());
        parser.setKind(8);
        parser.setSource(source);
        parser.setResolveBindings(this.resolveBindings);
        parser.setBindingsRecovery(this.bindingRecovery);
        parser.setStatementsRecovery(this.statementRecovery);
        List jdkClasspath = ClasspathUtil.getJDKClasspath();
        String[] classpathEntries = ClasspathUtil.createClasspathEntries((URI)jarURI, (List)jdkClasspath);
        boolean includeRunningVMBootclasspath = jdkClasspath.isEmpty();
        if (unitName.endsWith(".java")) {
            String[] sourcepathEntries = new String[]{jarURI.getPath()};
            String[] encodings = new String[]{StandardCharsets.UTF_8.name()};
            parser.setEnvironment(classpathEntries, sourcepathEntries, encodings, includeRunningVMBootclasspath);
            parser.setUnitName(unitName);
        }
        if (unitName.endsWith(".class")) {
            parser.setEnvironment(classpathEntries, null, null, includeRunningVMBootclasspath);
            parser.setUnitName(unitName.replace(".class", ".java"));
        }
        Map<String, String> options = ASTParserFactory.getDefaultOptions();
        String majorVersion = jarTojdkVersion.computeIfAbsent(jarURI, ASTParserFactory::resolveJDKVersion);
        options.put("org.eclipse.jdt.core.compiler.compliance", majorVersion);
        options.put("org.eclipse.jdt.core.compiler.source", majorVersion);
        options.put("org.eclipse.jdt.core.compiler.maxProblemPerUnit", String.valueOf(Integer.MAX_VALUE));
        options.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "warning");
        parser.setCompilerOptions(options);
        return parser;
    }

    private static String resolveJDKVersion(URI jarURI) {
        String majorVersion;
        block9: {
            File file = new File(jarURI);
            majorVersion = DEFAULT_JDK_VERSION;
            if (file.isFile() && file.getName().endsWith(".jar")) {
                try (JarFile jarFile = new JarFile(file);){
                    String jdkVersion;
                    Attributes mainAttributes;
                    Manifest manifest = jarFile.getManifest();
                    if (manifest != null && (mainAttributes = manifest.getMainAttributes()) != null && (jdkVersion = mainAttributes.getValue("Build-Jdk")) != null) {
                        majorVersion = ASTParserFactory.resolveJDKVersion(jdkVersion);
                    }
                }
                catch (IOException e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block9;
                    throw new AssertionError();
                }
            }
        }
        return majorVersion;
    }

    private static Map<String, String> getDefaultOptions() {
        Hashtable options = JavaCore.getOptions();
        options.put("org.eclipse.jdt.core.encoding", StandardCharsets.UTF_8.name());
        options.put("org.eclipse.jdt.core.compiler.compliance", DEFAULT_JDK_VERSION);
        options.put("org.eclipse.jdt.core.compiler.source", DEFAULT_JDK_VERSION);
        return options;
    }

    private static String resolveJDKVersion(String longVersion) {
        if (longVersion.startsWith("17")) {
            return "17";
        }
        if (longVersion.startsWith("16")) {
            return "16";
        }
        if (longVersion.startsWith("15")) {
            return "15";
        }
        if (longVersion.startsWith("14")) {
            return "14";
        }
        if (longVersion.startsWith("13")) {
            return "13";
        }
        if (longVersion.startsWith("12")) {
            return "12";
        }
        if (longVersion.startsWith("11")) {
            return "11";
        }
        if (longVersion.startsWith("10")) {
            return "10";
        }
        if (longVersion.startsWith("9")) {
            return "9";
        }
        if (longVersion.startsWith(DEFAULT_JDK_VERSION)) {
            return DEFAULT_JDK_VERSION;
        }
        if (longVersion.startsWith("1.7")) {
            return "1.7";
        }
        if (longVersion.startsWith("1.6")) {
            return "1.6";
        }
        if (longVersion.startsWith("1.5")) {
            return "1.5";
        }
        if (longVersion.startsWith("1.4")) {
            return "1.4";
        }
        if (longVersion.startsWith("1.3")) {
            return "1.3";
        }
        if (longVersion.startsWith("1.2")) {
            return "1.2";
        }
        if (longVersion.startsWith("1.1")) {
            return "1.1";
        }
        return DEFAULT_JDK_VERSION;
    }
}

