/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.util.net;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.concurrent.Future;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.api.model.Type;
import org.jd.gui.service.type.TypeFactoryService;
import org.jd.gui.spi.TypeFactory;

public final class UriUtil {
    private UriUtil() {
    }

    public static URI createURI(API api, Collection<Future<Indexes>> collectionOfFutureIndexes, Container.Entry entry, String query, String fragment) {
        URI uri = entry.getUri();
        try {
            Type type;
            String path = uri.getPath();
            TypeFactory typeFactory = TypeFactoryService.getInstance().get(entry);
            if (typeFactory != null && (type = typeFactory.make(api, entry, fragment)) != null) {
                path = UriUtil.getOuterPath(collectionOfFutureIndexes, entry, type);
            }
            return new URI(uri.getScheme(), uri.getHost(), path, query, fragment);
        }
        catch (URISyntaxException e) {
            assert (ExceptionUtil.printStackTrace((Throwable)e));
            return uri;
        }
    }

    private static String getOuterPath(Collection<Future<Indexes>> collectionOfFutureIndexes, Container.Entry entry, Type type) {
        block7: {
            String outerName = type.getOuterName();
            if (outerName != null) {
                try {
                    for (Future<Indexes> futureIndexes : collectionOfFutureIndexes) {
                        Collection outerEntries;
                        if (!futureIndexes.isDone() || (outerEntries = futureIndexes.get().getIndex("typeDeclarations").get(outerName)) == null) continue;
                        for (Container.Entry outerEntry : outerEntries) {
                            if (outerEntry.getContainer() != entry.getContainer()) continue;
                            return outerEntry.getUri().getPath();
                        }
                    }
                }
                catch (InterruptedException e) {
                    assert (ExceptionUtil.printStackTrace((Throwable)e));
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block7;
                    throw new AssertionError();
                }
            }
        }
        return entry.getUri().getPath();
    }
}

