/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.util.matcher;

public final class DescriptorMatcher {
    private DescriptorMatcher() {
    }

    public static boolean matchFieldDescriptors(String d1, String d2) {
        return DescriptorMatcher.matchDescriptors(new CharBuffer(d1), new CharBuffer(d2));
    }

    private static boolean matchDescriptors(CharBuffer cb1, CharBuffer cb2) {
        if (cb1.read() == '?') {
            if (cb2.read() == '?') {
                return true;
            }
            cb2.unread();
            return cb2.skipType();
        }
        cb1.unread();
        if (cb2.read() == '?') {
            return cb1.skipType();
        }
        cb2.unread();
        return cb1.compareTypeWith(cb2);
    }

    public static boolean matchMethodDescriptors(String d1, String d2) {
        CharBuffer cb1 = new CharBuffer(d1);
        CharBuffer cb2 = new CharBuffer(d2);
        if (cb1.read() != '(' || cb2.read() != '(') {
            return false;
        }
        if (cb1.read() == '*') {
            return true;
        }
        if (cb2.read() == '*') {
            return true;
        }
        cb1.unread();
        cb2.unread();
        while (cb2.get() != ')') {
            if (DescriptorMatcher.matchDescriptors(cb1, cb2)) continue;
            return false;
        }
        if (cb1.read() != ')' || cb2.read() != ')') {
            return false;
        }
        return DescriptorMatcher.matchDescriptors(cb1, cb2);
    }

    protected static class CharBuffer {
        private final char[] buffer;
        private final int length;
        private int offset;

        public CharBuffer(String s) {
            this.buffer = s.toCharArray();
            this.length = this.buffer.length;
            this.offset = 0;
        }

        public char read() {
            if (this.offset < this.length) {
                return this.buffer[this.offset++];
            }
            return '\u0000';
        }

        public boolean unread() {
            if (this.offset > 0) {
                --this.offset;
                return true;
            }
            return false;
        }

        public char get() {
            if (this.offset < this.length) {
                return this.buffer[this.offset];
            }
            return '\u0000';
        }

        public boolean skipType() {
            if (this.offset < this.length) {
                char c = this.buffer[this.offset++];
                while (c == '[' && this.offset < this.length) {
                    c = this.buffer[this.offset++];
                }
                if (c == 'L') {
                    while (this.offset < this.length) {
                        if (this.buffer[this.offset++] != ';') continue;
                        return true;
                    }
                } else if (c != '[') {
                    return true;
                }
            }
            return false;
        }

        public boolean compareTypeWith(CharBuffer other) {
            char c;
            if (this.offset >= this.length) {
                return false;
            }
            if ((c = this.buffer[this.offset++]) != other.read()) {
                return false;
            }
            if (c == 'L') {
                if (this.offset >= this.length || other.offset >= other.length) {
                    return false;
                }
                char[] otherBuffer = other.buffer;
                if (this.buffer[this.offset] != '*' && otherBuffer[other.offset] != '*') {
                    while (this.offset < this.length) {
                        if ((c = this.buffer[this.offset++]) != other.read()) {
                            return false;
                        }
                        if (c != ';') continue;
                        return true;
                    }
                    return false;
                }
                int start = this.offset;
                int otherStart = other.offset;
                if (!this.searchEndOfType() || !other.searchEndOfType()) {
                    return false;
                }
                int current = this.offset - 1;
                int otherCurrent = other.offset - 1;
                while (start < current && otherStart < otherCurrent) {
                    char otherC;
                    if ((c = this.buffer[--current]) == '*') {
                        return true;
                    }
                    if ((otherC = otherBuffer[--otherCurrent]) == '*') {
                        return true;
                    }
                    if (c == otherC) continue;
                    return false;
                }
            }
            return true;
        }

        protected boolean searchEndOfType() {
            while (this.offset < this.length) {
                if (this.buffer[this.offset++] != ';') continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return new String(this.buffer, this.offset, this.length - this.offset);
        }
    }
}

