/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.util.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class NewlineOutputStream
extends FilterOutputStream {
    private static final byte[] lineSeparator = System.lineSeparator().getBytes(StandardCharsets.UTF_8);

    public NewlineOutputStream(OutputStream os) {
        super(os);
    }

    @Override
    public void write(int b) throws IOException {
        if (b == 10) {
            this.out.write(lineSeparator);
        } else {
            this.out.write(b);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int i;
        for (i = off; i < len; ++i) {
            if (b[i] != 10) continue;
            this.out.write(b, off, i - off);
            this.out.write(lineSeparator);
            off = i + 1;
        }
        this.out.write(b, off, i - off);
    }
}

