/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.util.index;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.zip.ZipEntry;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;

public final class IndexesUtil {
    private IndexesUtil() {
    }

    public static boolean containsInternalTypeName(Collection<Future<Indexes>> collectionOfFutureIndexes, String internalTypeName) {
        return IndexesUtil.contains(collectionOfFutureIndexes, "typeDeclarations", internalTypeName);
    }

    public static List<Container.Entry> findInternalTypeName(Collection<Future<Indexes>> collectionOfFutureIndexes, String internalTypeName) {
        return IndexesUtil.find(collectionOfFutureIndexes, "typeDeclarations", internalTypeName);
    }

    public static boolean contains(Collection<Future<Indexes>> collectionOfFutureIndexes, String indexName, String key) {
        block5: {
            try {
                for (Future<Indexes> futureIndexes : collectionOfFutureIndexes) {
                    Map<String, Collection> index;
                    if (!futureIndexes.isDone() || (index = futureIndexes.get().getIndex(indexName)) == null || index.get(key) == null) continue;
                    return true;
                }
            }
            catch (InterruptedException e) {
                assert (ExceptionUtil.printStackTrace((Throwable)e));
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block5;
                throw new AssertionError();
            }
        }
        return false;
    }

    public static List<Container.Entry> find(Collection<Future<Indexes>> collectionOfFutureIndexes, String indexName, String key) {
        ArrayList<Container.Entry> entries;
        block5: {
            entries = new ArrayList<Container.Entry>();
            try {
                for (Future<Indexes> futureIndexes : collectionOfFutureIndexes) {
                    Collection collection;
                    Map<String, Collection> index;
                    if (!futureIndexes.isDone() || (index = futureIndexes.get().getIndex(indexName)) == null || (collection = index.get(key)) == null) continue;
                    entries.addAll(collection);
                }
            }
            catch (InterruptedException e) {
                assert (ExceptionUtil.printStackTrace((Throwable)e));
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block5;
                throw new AssertionError();
            }
        }
        return entries;
    }

    public static long entryImpactBytes(ZipEntry entry) {
        int nameSize = entry.getName().getBytes(StandardCharsets.UTF_8).length;
        int extraSize = entry.getExtra() != null ? entry.getExtra().length : 0;
        int commentSize = entry.getComment() != null ? entry.getComment().getBytes(StandardCharsets.UTF_8).length : 0;
        return entry.getCompressedSize() + 30L + (long)nameSize + (long)extraSize + 46L + (long)nameSize + (long)extraSize + (long)commentSize;
    }
}

