/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.util.decompiler;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.jd.core.v1.api.loader.Loader;
import org.jd.gui.api.model.Container;
import org.jd.gui.model.container.entry.path.FileEntryPath;

public class ContainerLoader
implements Loader {
    private Container.Entry entry;

    public ContainerLoader() {
        this.entry = null;
    }

    public ContainerLoader(Container.Entry entry) {
        this.entry = entry;
    }

    public void setEntry(Container.Entry e) {
        this.entry = e;
    }

    protected Container.Entry getEntry(String internalPath) {
        if (!internalPath.endsWith(".class")) {
            return this.getEntry(internalPath + ".class");
        }
        if (this.entry.getPath().equals(internalPath)) {
            return this.entry;
        }
        Map<Container.EntryPath, Container.Entry> children = this.entry.getParent().getChildren();
        return children.get(new FileEntryPath(internalPath));
    }

    public boolean canLoad(String internalPath) {
        return this.getEntry(internalPath) != null;
    }

    public byte[] load(String internalName) throws IOException {
        Container.Entry loadedEntry = this.getEntry(internalName);
        if (loadedEntry == null) {
            return null;
        }
        try (InputStream inputStream = loadedEntry.getInputStream();){
            byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
            return byArray;
        }
    }

    public static char[] loadEntry(Container.Entry entry, Charset charset) throws IOException {
        try (InputStream inputStream = entry.getInputStream();){
            char[] cArray = IOUtils.toCharArray((InputStream)inputStream, (Charset)charset);
            return cArray;
        }
    }
}

