/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.util.container;

import jadx.core.utils.StringUtils;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.model.Container;
import org.jd.gui.model.container.ContainerEntryComparator;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public final class JarContainerEntryUtil {
    private JarContainerEntryUtil() {
    }

    public static Collection<Container.Entry> removeInnerTypeEntries(Map<Container.EntryPath, Container.Entry> entries) {
        Map<Container.EntryPath, Container.Entry> filteredSubEntries;
        HashSet<CallSite> potentialOuterTypePaths = new HashSet<CallSite>();
        for (Container.Entry e : entries.values()) {
            int lastSeparatorIndex;
            int dollarIndex;
            String string;
            if (e.isDirectory() || !(string = e.getPath()).toLowerCase().endsWith(".class") || (dollarIndex = string.indexOf(36, (lastSeparatorIndex = string.lastIndexOf(47)) + 1)) == -1) continue;
            potentialOuterTypePaths.add((CallSite)((Object)(string.substring(0, dollarIndex) + ".class")));
        }
        if (potentialOuterTypePaths.isEmpty()) {
            filteredSubEntries = entries;
        } else {
            HashSet<String> innerTypePaths = new HashSet<String>();
            for (Container.Entry entry : entries.values()) {
                if (entry.isDirectory() || !potentialOuterTypePaths.contains(entry.getPath())) continue;
                JarContainerEntryUtil.populateInnerTypePaths(innerTypePaths, entry);
            }
            filteredSubEntries = new TreeMap<Container.EntryPath, Container.Entry>(ContainerEntryComparator.COMPARATOR);
            for (Map.Entry entry : entries.entrySet()) {
                int indexSeparator;
                int indexDollar;
                String p;
                Container.Entry e = (Container.Entry)entry.getValue();
                if (!e.isDirectory() && (p = e.getPath()).toLowerCase().endsWith(".class") && (indexDollar = p.lastIndexOf(36)) != -1 && indexDollar > (indexSeparator = p.lastIndexOf(47))) {
                    if (innerTypePaths.contains(p)) continue;
                    JarContainerEntryUtil.populateInnerTypePaths(innerTypePaths, e);
                    if (innerTypePaths.contains(p)) continue;
                }
                filteredSubEntries.put((Container.EntryPath)entry.getKey(), e);
            }
        }
        return filteredSubEntries.values();
    }

    private static void populateInnerTypePaths(final Set<String> innerTypePaths, Container.Entry entry) {
        block8: {
            try (InputStream is = entry.getInputStream();){
                ClassReader classReader = new ClassReader(is);
                String p = entry.getPath();
                final String prefixPath = p.substring(0, p.length() - classReader.getClassName().length() - 6);
                ClassVisitor classVisitor = new ClassVisitor(589824){

                    public void visitInnerClass(String name, String outerName, String innerName, int access) {
                        innerTypePaths.add(prefixPath + name + ".class");
                    }
                };
                classReader.accept(classVisitor, 7);
            }
            catch (Exception e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block8;
                throw new AssertionError();
            }
        }
    }

    public static String inferGroupFromFile(JarFile jarFile) {
        String group = JarContainerEntryUtil.inferGroupFromFile(jarFile, ".class");
        if (group == null) {
            group = JarContainerEntryUtil.inferGroupFromFile(jarFile, ".properties");
        }
        if (group == null) {
            group = "com.mycompany";
        }
        return group;
    }

    private static String inferGroupFromFile(JarFile jarFile, String extension) {
        HashSet<String> possibleGroups = new HashSet<String>();
        int minDepth = Integer.MAX_VALUE;
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry nextEntry = entries.nextElement();
            String entryName = nextEntry.getName();
            int idx = entryName.lastIndexOf(47);
            if (idx == -1 || extension != null && !entryName.endsWith(extension)) continue;
            String packageName = entryName.substring(0, idx);
            int currentDepth = StringUtils.countMatches((String)packageName, (String)"/");
            if (currentDepth < minDepth) {
                possibleGroups.clear();
                minDepth = currentDepth;
                possibleGroups.add(packageName.replace('/', '.'));
                continue;
            }
            if (currentDepth != minDepth) continue;
            possibleGroups.add(packageName.replace('/', '.'));
            idx = packageName.lastIndexOf(47);
            if (idx == -1 || possibleGroups.size() <= 1) continue;
            if (possibleGroups.size() != 2) {
                throw new IllegalStateException("2 groups expected");
            }
            String[] pairOfPossibleGroups = (String[])possibleGroups.toArray(String[]::new);
            for (int i = 0; i < pairOfPossibleGroups.length; ++i) {
                for (String prefix : Arrays.asList("org", "net", "com")) {
                    String otherPossibleGroup = pairOfPossibleGroups[(i + 1) % 2];
                    if (!pairOfPossibleGroups[i].startsWith(prefix) || otherPossibleGroup.startsWith(prefix)) continue;
                    possibleGroups.remove(otherPossibleGroup);
                }
            }
            if (possibleGroups.size() != 2) continue;
            possibleGroups.clear();
            possibleGroups.add(packageName.substring(0, idx).replace('/', '.'));
            --minDepth;
        }
        if (possibleGroups.isEmpty()) {
            return null;
        }
        return (String)possibleGroups.iterator().next();
    }
}

