/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import org.jd.gui.api.model.Container;

public final class ProgressUtil {
    private ProgressUtil() {
    }

    public static void updateProgress(Container.Entry root, Container.Entry entry, DoubleSupplier getProgressFunction, DoubleConsumer setProgressFunction) throws IOException {
        File file = new File(root.getUri());
        if (file.exists()) {
            double totalSize = Files.size(file.toPath());
            long entryLength = entry.compressedLength();
            double progress = (double)(100L * entryLength) / totalSize;
            double cumulativeProgress = getProgressFunction.getAsDouble() + progress;
            if (cumulativeProgress <= 100.0) {
                setProgressFunction.accept(cumulativeProgress);
            }
        } else {
            ProgressUtil.updateProgress(root.getParent(), entry, getProgressFunction, setProgressFunction);
        }
    }

    public static void updateProgress(Container.Entry entry, DoubleSupplier getProgressFunction, DoubleConsumer setProgressFunction) throws IOException {
        ProgressUtil.updateProgress(entry.getContainer().getRoot().getParent(), entry, getProgressFunction, setProgressFunction);
    }
}

