/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.util;

import java.net.URI;
import java.util.HashMap;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.model.Container;
import org.jd.gui.util.parser.jdt.ASTParserFactory;
import org.jd.util.Range;

public final class MethodPatcher {
    private MethodPatcher() {
    }

    public static String patchCode(final String sourceCodeV1, final String sourceCodeV0, Container.Entry entry) {
        Document document;
        block2: {
            final HashMap methodKeyPositionRanges = new HashMap();
            URI jarURI = entry.getContainer().getRoot().getParent().getUri();
            String unitName = entry.getPath();
            ASTParserFactory astParserFactory = ASTParserFactory.getInstanceWithBindings();
            CompilationUnit compilationUnit = (CompilationUnit)astParserFactory.newASTParser(sourceCodeV1.toCharArray(), unitName, jarURI).createAST(null);
            ASTRewrite rewriter = ASTRewrite.create((AST)compilationUnit.getAST());
            document = new Document(sourceCodeV1);
            final TextEdit textEdit = rewriter.rewriteAST((IDocument)document, null);
            compilationUnit.accept(new ASTVisitor(){

                public boolean visit(MethodDeclaration node) {
                    IMethodBinding methodBinding;
                    int methodEnd;
                    int methodStart;
                    String methodSource;
                    if (node.getBody() != null && (methodSource = sourceCodeV1.substring(methodStart = node.getBody().getStartPosition(), methodEnd = methodStart + node.getBody().getLength())).contains("Decompilation failed at line #") && (methodBinding = node.resolveBinding()) != null) {
                        String methodKey = methodBinding.getKey();
                        methodKeyPositionRanges.put(methodKey, Range.between(methodStart, methodEnd));
                    }
                    return super.visit(node);
                }
            });
            astParserFactory.newASTParser(sourceCodeV0.toCharArray(), unitName, jarURI).createAST(null).accept(new ASTVisitor(){

                public boolean visit(MethodDeclaration node) {
                    if (node.getBody() != null) {
                        int methodStart = node.getBody().getStartPosition();
                        int methodEnd = methodStart + node.getBody().getLength();
                        String methodV0 = sourceCodeV0.substring(methodStart, methodEnd);
                        IMethodBinding methodBinding = node.resolveBinding();
                        if (methodBinding != null) {
                            String methodKey = methodBinding.getKey();
                            Range rangeV1 = (Range)methodKeyPositionRanges.get(methodKey);
                            if (rangeV1 == null) {
                                methodKey = methodKey.replaceAll("L(\\w+/)*+", "L");
                                rangeV1 = (Range)methodKeyPositionRanges.get(methodKey);
                            }
                            if (rangeV1 != null) {
                                String methodV1 = sourceCodeV1.substring(rangeV1.minimum(), rangeV1.maximum());
                                int methodV0LineCount = (int)methodV0.lines().count();
                                int methodV1LineCount = (int)methodV1.lines().count();
                                StringBuilder newMethod = new StringBuilder(methodV0);
                                for (int i = 0; i < methodV1LineCount - methodV0LineCount; ++i) {
                                    newMethod.append(System.lineSeparator());
                                }
                                textEdit.addChild((TextEdit)new ReplaceEdit(rangeV1.minimum(), rangeV1.length(), newMethod.toString()));
                                textEdit.addChild((TextEdit)new InsertEdit(rangeV1.minimum(), "/* Patched from JD-Core V0 */"));
                            }
                        }
                    }
                    return super.visit(node);
                }
            });
            try {
                textEdit.apply((IDocument)document);
            }
            catch (BadLocationException | MalformedTreeException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block2;
                throw new AssertionError();
            }
        }
        return document.get();
    }
}

