/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.util;

import java.awt.Image;
import java.io.IOException;
import java.util.stream.Stream;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.jd.gui.util.CustomMultiResolutionImage;

public final class ImageUtil {
    private ImageUtil() {
    }

    public static ImageIcon newImageIcon(String iconPath) {
        return new ImageIcon(ImageUtil.getImage(iconPath));
    }

    public static Image getImage(String iconPath) {
        try {
            return new CustomMultiResolutionImage(iconPath);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid icon path : " + iconPath, e);
        }
    }

    public static void addJDIconsToFrame(JFrame frame) {
        frame.setIconImages(Stream.of(32, 64, 128).map(ImageUtil::getAppIconPath).map(ImageUtil::getImage).toList());
    }

    public static String getAppIconPath(int size) {
        return "/org/jd/gui/images/jd_icon_" + size + ".png";
    }
}

