/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.type;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Type;
import org.jd.gui.service.type.AbstractTypeFactoryProvider;
import org.jd.gui.util.parser.jdt.ASTParserFactory;
import org.jd.gui.util.parser.jdt.core.AbstractJavaListener;
import org.jd.util.LRUCache;

public class JavaFileTypeFactoryProvider
extends AbstractTypeFactoryProvider {
    protected LRUCache<URI, Listener> cache = new LRUCache();

    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:*.java");
    }

    @Override
    public Collection<Type> make(API api, Container.Entry entry) {
        Listener listener = this.getListener(entry);
        if (listener == null) {
            return Collections.emptyList();
        }
        return listener.getRootTypes();
    }

    @Override
    public Type make(API api, Container.Entry entry, String fragment) {
        Listener listener = this.getListener(entry);
        if (listener == null) {
            return null;
        }
        if (fragment != null && !fragment.isEmpty()) {
            int index = fragment.indexOf(45);
            if (index != -1) {
                fragment = fragment.substring(0, index);
            }
            return listener.getType(fragment);
        }
        return listener.getMainType();
    }

    protected Listener getListener(Container.Entry entry) {
        Listener listener;
        URI key = entry.getUri();
        if (this.cache.containsKey(key)) {
            return (Listener)((Object)this.cache.get(key));
        }
        try {
            listener = new Listener(entry);
            ASTParserFactory.getInstance().newASTParser(entry).createAST(null).accept((ASTVisitor)listener);
        }
        catch (IOException e) {
            assert (ExceptionUtil.printStackTrace((Throwable)e));
            listener = null;
        }
        this.cache.put(key, listener);
        return listener;
    }

    protected static class Listener
    extends AbstractJavaListener {
        private String displayPackageName = "";
        private JavaType mainType;
        private JavaType currentType;
        private List<Type> rootTypes = new ArrayList<Type>();
        private Map<String, Type> types = new HashMap<String, Type>();

        public Listener(Container.Entry entry) {
            super(entry);
        }

        public Type getMainType() {
            return this.mainType;
        }

        public Type getType(String typeName) {
            return this.types.get(typeName);
        }

        public List<Type> getRootTypes() {
            return this.rootTypes;
        }

        @Override
        public boolean visit(PackageDeclaration node) {
            if (super.visit(node)) {
                this.displayPackageName = node.getName().getFullyQualifiedName();
            }
            return true;
        }

        @Override
        protected boolean enterTypeDeclaration(AbstractTypeDeclaration node, int access) {
            String name = node.getName().getIdentifier();
            org.eclipse.jdt.core.dom.Type superType = this.getSuperType(node);
            String superQualifiedTypeName = superType == null ? ((access & 0x200) == 0 ? "java/lang/Object" : "") : this.resolveInternalTypeName(superType);
            access += node.getModifiers();
            if (this.currentType == null) {
                String internalTypeName = this.packageName.isEmpty() ? name : this.packageName + "/" + name;
                String outerName = null;
                String displayTypeName = name;
                String displayInnerTypeName = null;
                this.currentType = new JavaType(access, internalTypeName, superQualifiedTypeName, outerName, displayTypeName, displayInnerTypeName, this.displayPackageName, null);
                this.types.put(internalTypeName, this.currentType);
                this.rootTypes.add(this.currentType);
                this.nameToInternalTypeName.put(name, internalTypeName);
                if (this.mainType == null) {
                    this.mainType = this.currentType;
                } else {
                    String path = this.entry.getPath();
                    int index = path.lastIndexOf(47) + 1;
                    if (path.startsWith(name + ".", index)) {
                        this.mainType = this.currentType;
                    }
                }
            } else {
                String internalTypeName = this.currentType.getName() + "$" + name;
                String outerName = this.currentType.getName();
                String displayTypeName = this.currentType.getDisplayTypeName() + "." + name;
                String displayInnerTypeName = name;
                JavaType subType = new JavaType(access, internalTypeName, superQualifiedTypeName, outerName, displayTypeName, displayInnerTypeName, this.displayPackageName, this.currentType);
                this.currentType.getInnerTypes().add(subType);
                this.currentType = subType;
                this.types.put(internalTypeName, this.currentType);
                this.nameToInternalTypeName.put(name, internalTypeName);
            }
            return true;
        }

        @Override
        protected void exitTypeDeclaration() {
            this.currentType = this.currentType.getOuterType();
        }

        public boolean visit(Initializer node) {
            this.currentType.getMethods().add(new JavaMethod(this.currentType, 8, "<clinit>", "()V"));
            return true;
        }

        public boolean visit(FieldDeclaration node) {
            int access = node.getModifiers();
            List fragments = node.fragments();
            for (VariableDeclarationFragment fragment : fragments) {
                String name = fragment.getName().getIdentifier();
                int dimensionOnVariable = fragment.getExtraDimensions();
                String descriptor = this.createDescriptor(node.getType(), dimensionOnVariable);
                this.currentType.getFields().add(new JavaField(access, name, descriptor));
            }
            return true;
        }

        public boolean visit(MethodDeclaration node) {
            int access = node.getModifiers();
            String name = node.isConstructor() ? "<init>" : node.getName().getIdentifier();
            String paramDescriptors = this.createParamDescriptors(node.parameters());
            String returnDescriptor = this.createDescriptor(node.getReturnType2(), 0);
            String descriptor = paramDescriptors + returnDescriptor;
            this.currentType.getMethods().add(new JavaMethod(this.currentType, access, name, descriptor));
            return true;
        }
    }

    protected static class JavaMethod
    implements Type.Method {
        private JavaType type;
        private int access;
        private String name;
        private String descriptor;

        public JavaMethod(JavaType type, int access, String name, String descriptor) {
            this.type = type;
            this.access = access;
            this.name = name;
            this.descriptor = descriptor;
        }

        @Override
        public int getFlags() {
            return this.access;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescriptor() {
            return this.descriptor;
        }

        @Override
        public Icon getIcon() {
            return AbstractTypeFactoryProvider.getMethodIcon(this.access);
        }

        @Override
        public String getDisplayName() {
            boolean isInnerClass;
            String constructorName = this.type.getDisplayInnerTypeName();
            boolean bl = isInnerClass = constructorName != null;
            if (constructorName == null) {
                constructorName = this.type.getDisplayTypeName();
            }
            StringBuilder sb = new StringBuilder();
            AbstractTypeFactoryProvider.writeMethodSignature(sb, this.access, this.access, isInnerClass, constructorName, this.name, this.descriptor);
            return sb.toString();
        }
    }

    protected static class JavaField
    implements Type.Field {
        private int access;
        private String name;
        private String descriptor;

        public JavaField(int access, String name, String descriptor) {
            this.access = access;
            this.name = name;
            this.descriptor = descriptor;
        }

        @Override
        public int getFlags() {
            return this.access;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescriptor() {
            return this.descriptor;
        }

        @Override
        public Icon getIcon() {
            return AbstractTypeFactoryProvider.getFieldIcon(this.access);
        }

        @Override
        public String getDisplayName() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name).append(" : ");
            AbstractTypeFactoryProvider.writeSignature(sb, this.descriptor, this.descriptor.length(), 0, false);
            return sb.toString();
        }
    }

    protected static class JavaType
    implements Type {
        private int access;
        private String name;
        private String superName;
        private String outerName;
        private String displayTypeName;
        private String displayInnerTypeName;
        private String displayPackageName;
        private List<Type> innerTypes = new ArrayList<Type>();
        private List<Type.Field> fields = new ArrayList<Type.Field>();
        private List<Type.Method> methods = new ArrayList<Type.Method>();
        private JavaType outerType;

        public JavaType(int access, String name, String superName, String outerName, String displayTypeName, String displayInnerTypeName, String displayPackageName, JavaType outerType) {
            this.access = access;
            this.name = name;
            this.superName = superName;
            this.outerName = outerName;
            this.displayTypeName = displayTypeName;
            this.displayInnerTypeName = displayInnerTypeName;
            this.displayPackageName = displayPackageName;
            this.outerType = outerType;
        }

        @Override
        public int getFlags() {
            return this.access;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getSuperName() {
            return this.superName;
        }

        @Override
        public String getOuterName() {
            return this.outerName;
        }

        @Override
        public String getDisplayTypeName() {
            return this.displayTypeName;
        }

        @Override
        public String getDisplayInnerTypeName() {
            return this.displayInnerTypeName;
        }

        @Override
        public String getDisplayPackageName() {
            return this.displayPackageName;
        }

        @Override
        public Icon getIcon() {
            return AbstractTypeFactoryProvider.getTypeIcon(this.access);
        }

        public JavaType getOuterType() {
            return this.outerType;
        }

        @Override
        public Collection<Type> getInnerTypes() {
            return this.innerTypes;
        }

        @Override
        public Collection<Type.Field> getFields() {
            return this.fields;
        }

        @Override
        public Collection<Type.Method> getMethods() {
            return this.methods;
        }
    }
}

