/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.type;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Type;
import org.jd.gui.model.container.entry.path.FileEntryPath;
import org.jd.gui.service.type.AbstractTypeFactoryProvider;
import org.jd.util.LRUCache;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class ClassFileTypeFactoryProvider
extends AbstractTypeFactoryProvider {
    protected LRUCache<URI, JavaType> cache = new LRUCache();

    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:*.class");
    }

    @Override
    public Collection<Type> make(API api, Container.Entry entry) {
        return Collections.singletonList(this.make(api, entry, null));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Type make(API api, Container.Entry entry, String fragment) {
        JavaType type;
        URI key = entry.getUri();
        if (this.cache.containsKey(key)) {
            return (Type)this.cache.get(key);
        }
        try (InputStream is = entry.getInputStream();){
            ClassReader classReader = new ClassReader(is);
            if (fragment != null && !fragment.isEmpty()) {
                int index = fragment.indexOf(45);
                if (index != -1) {
                    fragment = fragment.substring(0, index);
                }
                if (!classReader.getClassName().equals(fragment)) {
                    Object entryTypePath = classReader.getClassName() + ".class";
                    Object fragmentTypePath = fragment + ".class";
                    while (true) {
                        if (entry.getPath().endsWith((String)entryTypePath)) {
                            String pathToFind = entry.getPath().substring(0, entry.getPath().length() - ((String)entryTypePath).length()) + (String)fragmentTypePath;
                            Container.Entry entryFound = entry.getParent().getChildren().get(new FileEntryPath(pathToFind));
                            if (entryFound == null) {
                                Type type2 = null;
                                return type2;
                            }
                            entry = entryFound;
                            try (InputStream is2 = entry.getInputStream();){
                                classReader = new ClassReader(is2);
                                break;
                            }
                            catch (IOException e) {
                                assert (ExceptionUtil.printStackTrace((Throwable)e));
                                Type type3 = null;
                                if (is == null) return type3;
                                is.close();
                                return type3;
                            }
                        }
                        int firstPackageSeparatorIndex = ((String)entryTypePath).indexOf(47);
                        if (firstPackageSeparatorIndex == -1) {
                            Type type4 = null;
                            return type4;
                        }
                        entryTypePath = ((String)entryTypePath).substring(firstPackageSeparatorIndex + 1);
                        fragmentTypePath = ((String)fragmentTypePath).substring(((String)fragmentTypePath).indexOf(47) + 1);
                    }
                }
            }
            type = new JavaType(entry, classReader, -1);
        }
        catch (IOException e) {
            assert (ExceptionUtil.printStackTrace((Throwable)e));
            type = null;
        }
        this.cache.put(key, type);
        return type;
    }

    static class JavaType
    implements Type {
        private final Container.Entry entry;
        private int access;
        private String name;
        private String superName;
        private String outerName;
        private String displayTypeName;
        private String displayInnerTypeName;
        private final String displayPackageName;
        private List<Type> innerTypes;
        private final List<Type.Field> fields = new ArrayList<Type.Field>();
        private final List<Type.Method> methods = new ArrayList<Type.Method>();

        protected JavaType(Container.Entry entry, ClassReader classReader, final int outerAccess) {
            this.entry = entry;
            this.name = "";
            ClassVisitor classAndInnerClassesVisitor = new ClassVisitor(589824){

                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    this.setFlags(outerAccess == -1 ? access : outerAccess);
                    this.setName(name);
                    this.setSuperName((String)((access & 0x200) != 0 && "java/lang/Object".equals(superName) ? null : superName));
                }

                public void visitInnerClass(String name, String outerName, String innerName, int access) {
                    block12: {
                        Container.Entry innerEntry;
                        if (this.getName().equals(name)) {
                            this.setOuterName(outerName);
                            this.setDisplayInnerTypeName(innerName);
                        } else if ((access & 0x1040) == 0 && this.getName().equals(outerName) && (innerEntry = this.getEntry(name)) != null) {
                            try (InputStream is = innerEntry.getInputStream();){
                                ClassReader classReader = new ClassReader(is);
                                if (innerTypes == null) {
                                    innerTypes = new ArrayList<Type>();
                                }
                                innerTypes.add(new JavaType(innerEntry, classReader, access));
                            }
                            catch (IOException e) {
                                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block12;
                                throw new AssertionError();
                            }
                        }
                    }
                }
            };
            classReader.accept(classAndInnerClassesVisitor, 7);
            int lastPackageSeparatorIndex = this.name.lastIndexOf(47);
            if (lastPackageSeparatorIndex == -1) {
                this.displayPackageName = "";
                this.displayTypeName = this.outerName == null ? this.name : this.getDisplayTypeName(this.outerName, 0) + "." + this.displayInnerTypeName;
            } else {
                this.displayPackageName = this.name.substring(0, lastPackageSeparatorIndex).replace('/', '.');
                this.displayTypeName = this.outerName == null ? this.name : this.getDisplayTypeName(this.outerName, lastPackageSeparatorIndex) + "." + this.displayInnerTypeName;
                this.displayTypeName = this.displayTypeName.substring(lastPackageSeparatorIndex + 1);
            }
            ClassVisitor fieldsAndMethodsVisitor = new ClassVisitor(589824){

                public FieldVisitor visitField(final int access, final String name, final String descriptor, String signature, Object value) {
                    if ((access & 0x5000) == 0) {
                        fields.add(new Type.Field(){

                            @Override
                            public int getFlags() {
                                return access;
                            }

                            @Override
                            public String getName() {
                                return name;
                            }

                            @Override
                            public String getDescriptor() {
                                return descriptor;
                            }

                            @Override
                            public Icon getIcon() {
                                return AbstractTypeFactoryProvider.getFieldIcon(access);
                            }

                            @Override
                            public String getDisplayName() {
                                StringBuilder sb = new StringBuilder();
                                sb.append(name).append(" : ");
                                AbstractTypeFactoryProvider.writeSignature(sb, descriptor, descriptor.length(), 0, false);
                                return sb.toString();
                            }
                        });
                    }
                    return null;
                }

                public MethodVisitor visitMethod(final int access, final String name, final String descriptor, String signature, String[] exceptions) {
                    if ((access & 0x5040) == 0) {
                        methods.add(new Type.Method(){

                            @Override
                            public int getFlags() {
                                return access;
                            }

                            @Override
                            public String getName() {
                                return name;
                            }

                            @Override
                            public String getDescriptor() {
                                return descriptor;
                            }

                            @Override
                            public Icon getIcon() {
                                return AbstractTypeFactoryProvider.getMethodIcon(access);
                            }

                            @Override
                            public String getDisplayName() {
                                boolean isInnerClass = this.getDisplayInnerTypeName() != null;
                                String constructorName = isInnerClass ? this.getDisplayInnerTypeName() : this.getDisplayTypeName();
                                StringBuilder sb = new StringBuilder();
                                AbstractTypeFactoryProvider.writeMethodSignature(sb, this.getFlags(), access, isInnerClass, constructorName, name, descriptor);
                                return sb.toString();
                            }
                        });
                    }
                    return null;
                }
            };
            classReader.accept(fieldsAndMethodsVisitor, 7);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected String getDisplayTypeName(String name, int packageLength) {
            int indexDollar = name.lastIndexOf(36);
            if (indexDollar <= packageLength) return name;
            Container.Entry loadedEntry = this.getEntry(name);
            if (loadedEntry == null) return name;
            try (InputStream is = loadedEntry.getInputStream();){
                ClassReader classReader = new ClassReader(is);
                InnerClassVisitor classVisitor = new InnerClassVisitor(name);
                classReader.accept((ClassVisitor)classVisitor, 7);
                String localOuterName = classVisitor.getOuterName();
                if (localOuterName == null) return name;
                String string = this.getDisplayTypeName(localOuterName, packageLength) + "." + classVisitor.getInnerName();
                return string;
            }
            catch (IOException e) {
                if ($assertionsDisabled) return name;
                if (ExceptionUtil.printStackTrace((Throwable)e)) return name;
                throw new AssertionError();
            }
        }

        protected Container.Entry getEntry(String typeName) {
            return this.entry.getParent().getChildren().get(new FileEntryPath(typeName + ".class"));
        }

        @Override
        public int getFlags() {
            return this.access;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getSuperName() {
            return this.superName;
        }

        @Override
        public String getOuterName() {
            return this.outerName;
        }

        @Override
        public String getDisplayPackageName() {
            return this.displayPackageName;
        }

        @Override
        public String getDisplayTypeName() {
            return this.displayTypeName;
        }

        @Override
        public String getDisplayInnerTypeName() {
            return this.displayInnerTypeName;
        }

        @Override
        public Icon getIcon() {
            return AbstractTypeFactoryProvider.getTypeIcon(this.access);
        }

        public List<Type> getInnerTypes() {
            return this.innerTypes;
        }

        public List<Type.Field> getFields() {
            return this.fields;
        }

        public List<Type.Method> getMethods() {
            return this.methods;
        }

        public Container.Entry getEntry() {
            return this.entry;
        }

        private void setFlags(int access) {
            this.access = access;
        }

        private void setName(String name) {
            this.name = name;
        }

        private void setSuperName(String superName) {
            this.superName = superName;
        }

        private void setOuterName(String outerName) {
            this.outerName = outerName;
        }

        private void setDisplayInnerTypeName(String displayInnerTypeName) {
            this.displayInnerTypeName = displayInnerTypeName;
        }
    }

    protected static class InnerClassVisitor
    extends ClassVisitor {
        private String name;
        private String outerName;
        private String innerName;

        public InnerClassVisitor(String name) {
            super(589824);
            this.name = name;
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            if (this.name.equals(name)) {
                this.outerName = outerName;
                this.innerName = innerName;
            }
        }

        public String getOuterName() {
            return this.outerName;
        }

        public String getInnerName() {
            return this.innerName;
        }
    }
}

