/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.treenode;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jd.gui.api.model.Container;
import org.jd.gui.service.extension.ExtensionService;
import org.jd.gui.spi.TreeNodeFactory;

public class TreeNodeFactoryService {
    protected static final TreeNodeFactoryService TREE_NODE_FACTORY_SERVICE = new TreeNodeFactoryService();
    private final Map<String, TreeNodeFactories> mapProviders = new HashMap<String, TreeNodeFactories>();

    public static TreeNodeFactoryService getInstance() {
        return TREE_NODE_FACTORY_SERVICE;
    }

    protected TreeNodeFactoryService() {
        Collection<TreeNodeFactory> providers = ExtensionService.getInstance().load(TreeNodeFactory.class);
        for (TreeNodeFactory provider : providers) {
            for (String selector : provider.getSelectors()) {
                this.mapProviders.computeIfAbsent(selector, k -> new TreeNodeFactories()).add(provider);
            }
        }
    }

    public TreeNodeFactory get(Container.Entry entry) {
        TreeNodeFactory factory = this.get(entry.getContainer().getType(), entry);
        return factory != null ? factory : this.get("*", entry);
    }

    protected TreeNodeFactory get(String containerType, Container.Entry entry) {
        String path = entry.getPath();
        String type = entry.isDirectory() ? "dir" : "file";
        String prefix = containerType + ":" + type + ":";
        TreeNodeFactory factory = null;
        TreeNodeFactories factories = this.mapProviders.get(prefix + path);
        if (factories != null) {
            factory = factories.match(path);
        }
        if (factory == null) {
            int lastSlashIndex = path.lastIndexOf(47);
            String name = path.substring(lastSlashIndex + 1);
            factories = this.mapProviders.get(prefix + "*/" + name);
            if (factories != null) {
                factory = factories.match(path);
            }
            if (factory == null) {
                String extension;
                int index = name.lastIndexOf(46);
                if (index != -1 && (factories = this.mapProviders.get(prefix + "*." + (extension = name.substring(index + 1)))) != null) {
                    factory = factories.match(path);
                }
                if (factory == null && (factories = this.mapProviders.get(prefix + "*")) != null) {
                    factory = factories.match(path);
                }
            }
        }
        return factory;
    }

    protected static class TreeNodeFactories {
        private final Map<String, TreeNodeFactory> factories = new HashMap<String, TreeNodeFactory>();
        private TreeNodeFactory defaultFactory;

        protected TreeNodeFactories() {
        }

        public void add(TreeNodeFactory factory) {
            if (factory.getPathPattern() != null) {
                this.factories.put(factory.getPathPattern().pattern(), factory);
            } else {
                this.defaultFactory = factory;
            }
        }

        public TreeNodeFactory match(String path) {
            for (TreeNodeFactory factory : this.factories.values()) {
                if (!factory.getPathPattern().matcher(path).matches()) continue;
                return factory;
            }
            return this.defaultFactory;
        }
    }
}

