/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.treenode;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.PageCreator;
import org.jd.gui.api.feature.UriGettable;
import org.jd.gui.api.model.Container;
import org.jd.gui.service.treenode.FileTreeNodeFactoryProvider;
import org.jd.gui.util.ImageUtil;
import org.jd.gui.util.io.TextReader;
import org.jd.gui.view.component.TextPage;
import org.jd.gui.view.data.TreeNodeBean;

public class TextFileTreeNodeFactoryProvider
extends FileTreeNodeFactoryProvider {
    protected static final ImageIcon ICON;

    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:*.txt", "*:file:*.md", "*:file:*.SF", "*:file:*.policy", "*:file:*.yaml", "*:file:*.yml", "*:file:*/COPYRIGHT", "*:file:*/LICENSE", "*:file:*.cnd", "*:file:*.drl", "*:file:*.dsl");
    }

    @Override
    public <T extends DefaultMutableTreeNode & UriGettable> T make(API api, Container.Entry entry) {
        int lastSlashIndex = entry.getPath().lastIndexOf("/");
        String label = entry.getPath().substring(lastSlashIndex + 1);
        String location = new File(entry.getUri()).getPath();
        return (T)new TreeNode(entry, new TreeNodeBean(label, "Location: " + location, ICON));
    }

    static {
        block8: {
            ICON = new ImageIcon(ImageUtil.getImage("/org/jd/gui/images/ascii_obj.png"));
            try (InputStream inputStream = TextFileTreeNodeFactoryProvider.class.getClassLoader().getResourceAsStream("rsyntaxtextarea/themes/eclipse.xml");){
                Theme.load((InputStream)inputStream);
            }
            catch (IOException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block8;
                throw new AssertionError();
            }
        }
    }

    protected static class TreeNode
    extends FileTreeNodeFactoryProvider.TreeNode
    implements PageCreator {
        private static final long serialVersionUID = 1L;

        public TreeNode(Container.Entry entry, Object userObject) {
            super(entry, userObject);
        }

        @Override
        public <T extends JComponent> T createPage(API api) {
            return (T)new Page(this.entry);
        }
    }

    protected static class Page
    extends TextPage
    implements UriGettable {
        private static final long serialVersionUID = 1L;
        private transient Container.Entry entry;

        public Page(Container.Entry entry) {
            block8: {
                this.entry = entry;
                try (InputStream inputStream = entry.getInputStream();){
                    this.setText(TextReader.getText(inputStream));
                }
                catch (IOException e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block8;
                    throw new AssertionError();
                }
            }
        }

        @Override
        public URI getUri() {
            return this.entry.getUri();
        }

        @Override
        public String getFileName() {
            String path = this.entry.getPath();
            int index = path.lastIndexOf("/");
            return path.substring(index + 1);
        }
    }
}

