/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.treenode;

import java.io.File;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.PageCreator;
import org.jd.gui.api.feature.UriGettable;
import org.jd.gui.api.model.Container;
import org.jd.gui.service.treenode.FileTreeNodeFactoryProvider;
import org.jd.gui.util.ImageUtil;
import org.jd.gui.view.component.OneTypeReferencePerLinePage;
import org.jd.gui.view.data.TreeNodeBean;

public class MetainfServiceFileTreeNodeFactoryProvider
extends FileTreeNodeFactoryProvider {
    protected static final ImageIcon ICON = new ImageIcon(ImageUtil.getImage("/org/jd/gui/images/ascii_obj.png"));

    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:*");
    }

    @Override
    public Pattern getPathPattern() {
        if (this.externalPathPattern == null) {
            return Pattern.compile("META-INF\\/services\\/[^\\/]+");
        }
        return this.externalPathPattern;
    }

    @Override
    public <T extends DefaultMutableTreeNode & UriGettable> T make(API api, Container.Entry entry) {
        int lastSlashIndex = entry.getPath().lastIndexOf("/");
        String label = entry.getPath().substring(lastSlashIndex + 1);
        String location = new File(entry.getUri()).getPath();
        return (T)new TreeNode(entry, new TreeNodeBean(label, "Location: " + location, ICON));
    }

    protected static class TreeNode
    extends FileTreeNodeFactoryProvider.TreeNode
    implements PageCreator {
        private static final long serialVersionUID = 1L;

        public TreeNode(Container.Entry entry, Object userObject) {
            super(entry, userObject);
        }

        @Override
        public <T extends JComponent> T createPage(API api) {
            return (T)new OneTypeReferencePerLinePage(api, this.entry);
        }
    }
}

