/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.treenode;

import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.UriGettable;
import org.jd.gui.api.model.Container;
import org.jd.gui.service.treenode.TextFileTreeNodeFactoryProvider;
import org.jd.gui.util.ImageUtil;
import org.jd.gui.view.data.TreeNodeBean;

public class JspFileTreeNodeFactoryProvider
extends TextFileTreeNodeFactoryProvider {
    protected static final ImageIcon ICON = new ImageIcon(ImageUtil.getImage("/org/jd/gui/images/html_obj.gif"));

    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:*.jsp", "*:file:*.jspf");
    }

    @Override
    public <T extends DefaultMutableTreeNode & UriGettable> T make(API api, Container.Entry entry) {
        int lastSlashIndex = entry.getPath().lastIndexOf("/");
        String label = entry.getPath().substring(lastSlashIndex + 1);
        String location = new File(entry.getUri()).getPath();
        return (T)new TreeNode(entry, new TreeNodeBean(label, "Location: " + location, ICON));
    }

    protected static class TreeNode
    extends TextFileTreeNodeFactoryProvider.TreeNode {
        private static final long serialVersionUID = 1L;

        public TreeNode(Container.Entry entry, Object userObject) {
            super(entry, userObject);
        }

        @Override
        public <T extends JComponent> T createPage(API api) {
            return (T)new TextFileTreeNodeFactoryProvider.Page(this.entry){
                private static final long serialVersionUID = 1L;

                @Override
                public String getSyntaxStyle() {
                    return "text/jsp";
                }
            };
        }
    }
}

