/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.treenode;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.UriGettable;
import org.jd.gui.api.model.Container;
import org.jd.gui.model.container.entry.path.DirectoryEntryPath;
import org.jd.gui.service.treenode.ZipFileTreeNodeFactoryProvider;
import org.jd.gui.util.ImageUtil;
import org.jd.gui.util.container.JarContainerEntryUtil;
import org.jd.gui.view.data.TreeNodeBean;

public class JarFileTreeNodeFactoryProvider
extends ZipFileTreeNodeFactoryProvider {
    protected static final ImageIcon JAR_FILE_ICON = new ImageIcon(ImageUtil.getImage("/org/jd/gui/images/jar_obj.png"));
    protected static final ImageIcon EJB_FILE_ICON = new ImageIcon(ImageUtil.getImage("/org/jd/gui/images/ejbmodule_obj.gif"));

    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:*.jar");
    }

    @Override
    public <T extends DefaultMutableTreeNode & UriGettable> T make(API api, Container.Entry entry) {
        int lastSlashIndex = entry.getPath().lastIndexOf("/");
        String label = entry.getPath().substring(lastSlashIndex + 1);
        String location = new File(entry.getUri()).getPath();
        ImageIcon icon = JarFileTreeNodeFactoryProvider.isAEjbModule(entry) ? EJB_FILE_ICON : JAR_FILE_ICON;
        TreeNode node = new TreeNode(entry, (Object)new TreeNodeBean(label, "Location: " + location, icon));
        node.add(new DefaultMutableTreeNode());
        return (T)node;
    }

    protected static boolean isAEjbModule(Container.Entry entry) {
        Container.Entry metaInf;
        Map<Container.EntryPath, Container.Entry> children = entry.getChildren();
        return children != null && (metaInf = children.get(new DirectoryEntryPath("META-INF"))) != null && (children = metaInf.getChildren()).containsKey(new DirectoryEntryPath("META-INF/ejb-jar.xml"));
    }

    protected class TreeNode
    extends ZipFileTreeNodeFactoryProvider.TreeNode {
        private static final long serialVersionUID = 1L;

        public TreeNode(Container.Entry entry, Object userObject) {
            super(JarFileTreeNodeFactoryProvider.this, entry, userObject);
        }

        @Override
        public Collection<Container.Entry> getChildren() {
            return JarContainerEntryUtil.removeInnerTypeEntries(this.entry.getChildren());
        }
    }
}

