/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.treenode;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.ContainerEntryGettable;
import org.jd.gui.api.feature.TreeNodeExpandable;
import org.jd.gui.api.feature.UriGettable;
import org.jd.gui.api.model.Container;
import org.jd.gui.service.treenode.AbstractTreeNodeFactoryProvider;
import org.jd.gui.spi.TreeNodeFactory;
import org.jd.gui.util.ImageUtil;
import org.jd.gui.view.data.TreeNodeBean;

public class DirectoryTreeNodeFactoryProvider
extends AbstractTreeNodeFactoryProvider {
    protected static final ImageIcon ICON = new ImageIcon(ImageUtil.getImage("/org/jd/gui/images/folder.gif"));
    protected static final ImageIcon OPEN_ICON = new ImageIcon(ImageUtil.getImage("/org/jd/gui/images/folder_open.png"));

    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:dir:*");
    }

    @Override
    public <T extends DefaultMutableTreeNode & UriGettable> T make(API api, Container.Entry entry) {
        Container.Entry child;
        int lastSlashIndex = entry.getPath().lastIndexOf(47);
        Collection<Container.Entry> entries = entry.getChildren().values();
        while (entries.size() == 1 && (child = entries.iterator().next()).isDirectory() && api.getTreeNodeFactory(child) == this && entry.getContainer() == child.getContainer()) {
            entry = child;
            entries = entry.getChildren().values();
        }
        String label = entry.getPath().substring(lastSlashIndex + 1);
        String location = new File(entry.getUri()).getPath();
        TreeNode node = new TreeNode(entry, new TreeNodeBean(label, "Location: " + location, this.getIcon(), this.getOpenIcon()));
        if (!entries.isEmpty()) {
            node.add(new DefaultMutableTreeNode());
        }
        return (T)node;
    }

    public ImageIcon getIcon() {
        return ICON;
    }

    public ImageIcon getOpenIcon() {
        return OPEN_ICON;
    }

    protected class TreeNode
    extends DefaultMutableTreeNode
    implements ContainerEntryGettable,
    UriGettable,
    TreeNodeExpandable {
        private static final long serialVersionUID = 1L;
        protected transient Container.Entry entry;
        protected boolean initialized;

        public TreeNode(Container.Entry entry, Object userObject) {
            super(userObject);
            this.entry = entry;
            this.initialized = false;
        }

        @Override
        public Container.Entry getEntry() {
            return this.entry;
        }

        @Override
        public URI getUri() {
            return this.entry.getUri();
        }

        @Override
        public void populateTreeNode(API api) {
            if (!this.initialized) {
                Container.Entry child;
                this.removeAllChildren();
                Collection<Container.Entry> entries = this.getChildren();
                while (entries.size() == 1 && (child = entries.iterator().next()).isDirectory() && api.getTreeNodeFactory(child) == DirectoryTreeNodeFactoryProvider.this) {
                    entries = child.getChildren().values();
                }
                for (Container.Entry nextEntry : entries) {
                    TreeNodeFactory factory = api.getTreeNodeFactory(nextEntry);
                    if (factory == null) continue;
                    this.add((MutableTreeNode)factory.make(api, nextEntry));
                }
                this.initialized = true;
            }
        }

        public Collection<Container.Entry> getChildren() {
            return this.entry.getChildren().values();
        }
    }
}

