/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.treenode;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.bcel.classfile.ClassFormatException;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.UriGettable;
import org.jd.gui.api.model.Container;
import org.jd.gui.service.treenode.AbstractTypeFileTreeNodeFactoryProvider;
import org.jd.gui.util.ImageUtil;
import org.jd.gui.view.component.DynamicPage;
import org.jd.gui.view.data.ClassFileTreeNodeBean;

public class ClassFileTreeNodeFactoryProvider
extends AbstractTypeFileTreeNodeFactoryProvider {
    public static final ImageIcon CLASS_FILE_ICON = new ImageIcon(ImageUtil.getImage("/org/jd/gui/images/classf_obj.png"));
    public static final ImageIcon CLASS_FILE_ICON_ERROR = new ImageIcon(ImageUtil.getImage("/org/jd/gui/images/classf_obj_error.png"));
    public static final ImageIcon CLASS_FILE_ICON_WARNING = new ImageIcon(ImageUtil.getImage("/org/jd/gui/images/classf_obj_warning.png"));
    public static final Factory FACTORY = new Factory();

    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:*.class");
    }

    @Override
    public Pattern getPathPattern() {
        if (this.externalPathPattern == null) {
            return Pattern.compile("^((?!module-info\\.class).)*$");
        }
        return this.externalPathPattern;
    }

    @Override
    public <T extends DefaultMutableTreeNode & UriGettable> T make(API api, Container.Entry entry) {
        int lastSlashIndex = entry.getPath().lastIndexOf(47);
        String label = entry.getPath().substring(lastSlashIndex + 1);
        ClassFileTreeNodeBean treeNodeBean = new ClassFileTreeNodeBean(api, label, entry);
        AbstractTypeFileTreeNodeFactoryProvider.FileTreeNode fileTreeNode = new AbstractTypeFileTreeNodeFactoryProvider.FileTreeNode(entry, treeNodeBean, FACTORY);
        treeNodeBean.getWorker().execute();
        return (T)fileTreeNode;
    }

    protected static class Factory
    implements AbstractTypeFileTreeNodeFactoryProvider.PageAndTipFactory {
        protected Factory() {
        }

        @Override
        public <T extends JComponent> T makePage(API a, Container.Entry e) {
            return (T)new DynamicPage(a, e);
        }

        @Override
        public String makeTip(API api, Container.Entry entry) {
            StringBuilder tip;
            block11: {
                String location = new File(entry.getUri()).getPath();
                tip = new StringBuilder("<html>Location: ");
                tip.append(location);
                tip.append("<br>Java compiler version: ");
                try (DataInputStream is = new DataInputStream(entry.getInputStream());){
                    int magic = is.readInt();
                    if (magic != -889275714) {
                        throw new ClassFormatException("Invalid CLASS file");
                    }
                    int minorVersion = this.readUnsignedShort(is);
                    int majorVersion = this.readUnsignedShort(is);
                    if (majorVersion >= 49) {
                        tip.append(majorVersion - 44);
                    } else if (majorVersion >= 45) {
                        tip.append("1.");
                        tip.append(majorVersion - 44);
                    }
                    tip.append(" (");
                    tip.append(majorVersion);
                    tip.append('.');
                    tip.append(minorVersion);
                    tip.append(')');
                }
                catch (IOException e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block11;
                    throw new AssertionError();
                }
            }
            tip.append("</html>");
            return tip.toString();
        }

        protected int readUnsignedShort(InputStream is) throws IOException {
            int ch2;
            int ch1 = is.read();
            if ((ch1 | (ch2 = is.read())) < 0) {
                throw new EOFException();
            }
            return (ch1 << 8) + ch2;
        }
    }
}

