/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.treenode;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.ContainerEntryGettable;
import org.jd.gui.api.feature.PageCreator;
import org.jd.gui.api.feature.TreeNodeExpandable;
import org.jd.gui.api.feature.UriGettable;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Type;
import org.jd.gui.service.treenode.AbstractTreeNodeFactoryProvider;
import org.jd.gui.spi.TypeFactory;
import org.jd.gui.view.data.TreeNodeBean;

public abstract class AbstractTypeFileTreeNodeFactoryProvider
extends AbstractTreeNodeFactoryProvider {

    protected static interface PageAndTipFactory {
        public <T extends JComponent> T makePage(API var1, Container.Entry var2);

        public String makeTip(API var1, Container.Entry var2);
    }

    protected static class FieldOrMethodBean {
        private final String fragment;
        private final String label;
        private final Icon icon;

        public FieldOrMethodBean(String fragment, String label, Icon icon) {
            this.fragment = fragment;
            this.label = label;
            this.icon = icon;
        }

        public String getLabel() {
            return this.label;
        }
    }

    protected static class FieldOrMethodTreeNode
    extends BaseTreeNode {
        private static final long serialVersionUID = 1L;

        public FieldOrMethodTreeNode(Container.Entry entry, String fragment, Object userObject, PageAndTipFactory factory) {
            super(entry, fragment, userObject, factory);
        }
    }

    protected static class TypeTreeNode
    extends BaseTreeNode
    implements TreeNodeExpandable {
        private static final long serialVersionUID = 1L;
        private boolean initialized = false;
        private transient Type type;

        public TypeTreeNode(Container.Entry entry, Type type, Object userObject, PageAndTipFactory factory) {
            super(entry, type.getName(), userObject, factory);
            this.type = type;
            this.add(new DefaultMutableTreeNode());
        }

        @Override
        public void populateTreeNode(API api) {
            if (!this.initialized) {
                Collection<Type.Method> methods;
                Collection<Type.Field> fields;
                this.removeAllChildren();
                String typeName = this.type.getName();
                Collection<Type> innerTypes = this.type.getInnerTypes();
                if (innerTypes != null) {
                    ArrayList<Type> innerTypeList = new ArrayList<Type>(innerTypes);
                    innerTypeList.sort(Comparator.comparing(Type::getName));
                    for (Type type : innerTypeList) {
                        this.add(new TypeTreeNode(this.entry, type, (Object)new TreeNodeBean(type.getDisplayInnerTypeName(), type.getIcon()), this.factory));
                    }
                }
                if ((fields = this.type.getFields()) != null) {
                    ArrayList<FieldOrMethodBean> beans = new ArrayList<FieldOrMethodBean>(fields.size());
                    for (Type.Field field : fields) {
                        String fragment = typeName + "-" + field.getName() + "-" + field.getDescriptor();
                        beans.add(new FieldOrMethodBean(fragment, field.getDisplayName(), field.getIcon()));
                    }
                    beans.sort(Comparator.comparing(FieldOrMethodBean::getLabel));
                    for (FieldOrMethodBean bean : beans) {
                        this.add(new FieldOrMethodTreeNode(this.entry, bean.fragment, new TreeNodeBean(bean.label, bean.icon), this.factory));
                    }
                }
                if ((methods = this.type.getMethods()) != null) {
                    ArrayList<FieldOrMethodBean> arrayList = new ArrayList<FieldOrMethodBean>();
                    for (Type.Method method : methods) {
                        if ("<clinit>".equals(method.getName())) continue;
                        String fragment = typeName + "-" + method.getName() + "-" + method.getDescriptor();
                        arrayList.add(new FieldOrMethodBean(fragment, method.getDisplayName(), method.getIcon()));
                    }
                    arrayList.sort(Comparator.comparing(FieldOrMethodBean::getLabel));
                    for (FieldOrMethodBean bean : arrayList) {
                        this.add(new FieldOrMethodTreeNode(this.entry, bean.fragment, new TreeNodeBean(bean.label, bean.icon), this.factory));
                    }
                }
                this.initialized = true;
            }
        }
    }

    protected static class FileTreeNode
    extends BaseTreeNode
    implements TreeNodeExpandable {
        private static final long serialVersionUID = 1L;
        protected boolean initialized = false;

        public FileTreeNode(Container.Entry entry, Object userObject, PageAndTipFactory pageAndTipFactory) {
            this(entry, null, userObject, pageAndTipFactory);
        }

        public FileTreeNode(Container.Entry entry, String fragment, Object userObject, PageAndTipFactory factory) {
            super(entry, fragment, userObject, factory);
            this.add(new DefaultMutableTreeNode());
        }

        @Override
        public void populateTreeNode(API api) {
            if (!this.initialized) {
                this.removeAllChildren();
                TypeFactory typeFactory = api.getTypeFactory(this.entry);
                if (typeFactory != null) {
                    Collection<Type> types = typeFactory.make(api, this.entry);
                    for (Type type : types) {
                        this.add(new TypeTreeNode(this.entry, type, (Object)new TreeNodeBean(type.getDisplayTypeName(), type.getIcon()), this.factory));
                    }
                }
                this.initialized = true;
            }
        }
    }

    public static class BaseTreeNode
    extends DefaultMutableTreeNode
    implements ContainerEntryGettable,
    UriGettable,
    PageCreator {
        private static final long serialVersionUID = 1L;
        protected transient Container.Entry entry;
        protected transient PageAndTipFactory factory;
        private transient URI uri;

        public BaseTreeNode(Container.Entry entry, String fragment, Object userObject, PageAndTipFactory factory) {
            super(userObject);
            this.entry = entry;
            this.factory = factory;
            if (fragment != null) {
                try {
                    URI localURI = entry.getUri();
                    this.uri = new URI(localURI.getScheme(), localURI.getHost(), localURI.getPath(), fragment);
                }
                catch (URISyntaxException e) {
                    assert (ExceptionUtil.printStackTrace((Throwable)e));
                }
            } else {
                this.uri = entry.getUri();
            }
        }

        @Override
        public Container.Entry getEntry() {
            return this.entry;
        }

        @Override
        public URI getUri() {
            return this.uri;
        }

        @Override
        public <T extends JComponent> T createPage(API api) {
            ((TreeNodeBean)this.userObject).setTip(this.factory.makeTip(api, this.entry));
            return this.factory.makePage(api, this.entry);
        }
    }
}

