/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.treenode;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.plaf.IconUIResource;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.spi.TreeNodeFactory;
import org.jd.gui.util.ImageUtil;

public abstract class AbstractTreeNodeFactoryProvider
implements TreeNodeFactory {
    public static final ImageIcon COLLAPSED_ICON = new ImageIcon(ImageUtil.getImage("/org/jd/gui/images/plus.png"));
    public static final ImageIcon EXPANDED_ICON = new ImageIcon(ImageUtil.getImage("/org/jd/gui/images/minus.png"));
    private List<String> externalSelectors;
    protected Pattern externalPathPattern;

    protected AbstractTreeNodeFactoryProvider() {
        Properties properties;
        block9: {
            properties = new Properties();
            Class<?> clazz = this.getClass();
            try (InputStream is = clazz.getClassLoader().getResourceAsStream(clazz.getName().replace('.', '/') + ".properties");){
                if (is != null) {
                    properties.load(is);
                }
            }
            catch (IOException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block9;
                throw new AssertionError();
            }
        }
        this.init(properties);
    }

    protected void init(Properties properties) {
        String pathRegExp;
        String selectors = properties.getProperty("selectors");
        if (selectors != null) {
            this.externalSelectors = Arrays.asList(selectors.split(","));
        }
        if ((pathRegExp = properties.getProperty("pathRegExp")) != null) {
            this.externalPathPattern = Pattern.compile(pathRegExp);
        }
    }

    protected String[] appendSelectors(String selector) {
        if (this.externalSelectors == null) {
            return new String[]{selector};
        }
        int size = this.externalSelectors.size();
        String[] array = new String[size + 1];
        this.externalSelectors.toArray(array);
        array[size] = selector;
        return array;
    }

    protected String[] appendSelectors(String ... selectors) {
        if (this.externalSelectors == null) {
            return selectors;
        }
        int size = this.externalSelectors.size();
        String[] array = new String[size + selectors.length];
        this.externalSelectors.toArray(array);
        System.arraycopy(selectors, 0, array, size, selectors.length);
        return array;
    }

    @Override
    public Pattern getPathPattern() {
        return this.externalPathPattern;
    }

    static {
        UIManager.put("Tree.collapsedIcon", new IconUIResource(COLLAPSED_ICON));
        UIManager.put("Tree.expandedIcon", new IconUIResource(EXPANDED_ICON));
    }
}

