/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.sourcesaver;

import java.io.File;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.service.sourcesaver.DirectorySourceSaverProvider;

public class ZipFileSourceSaverProvider
extends DirectorySourceSaverProvider {
    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:*.zip", "*:file:*.jar", "*:file:*.war", "*:file:*.ear", "*:file:*.aar", "*:file:*.jmod", "*:file:*.kar");
    }

    @Override
    public void save(API api, Path rootPath, Container.Entry entry, DoubleSupplier getProgressFunction, DoubleConsumer setProgressFunction, BooleanSupplier isCancelledFunction) {
        block10: {
            try {
                File tmpSourceFile;
                String sourcePath = this.getSourcePath(entry);
                Path path = rootPath.resolve(sourcePath);
                Path parentPath = path.getParent();
                if (parentPath != null && !Files.exists(parentPath, new LinkOption[0])) {
                    Files.createDirectories(parentPath, new FileAttribute[0]);
                }
                if ((tmpSourceFile = api.loadSourceFile(entry)) != null) {
                    Files.copy(tmpSourceFile.toPath(), path, new CopyOption[0]);
                    break block10;
                }
                File tmpFile = File.createTempFile("jd-gui.", ".tmp.zip");
                Files.delete(tmpFile.toPath());
                tmpFile.deleteOnExit();
                URI tmpFileUri = tmpFile.toURI();
                URI tmpArchiveUri = new URI("jar:" + tmpFileUri.getScheme(), tmpFileUri.getHost(), tmpFileUri.getPath() + "!/", null);
                HashMap<String, String> env = new HashMap<String, String>();
                env.put("create", "true");
                try (FileSystem tmpArchiveFs = FileSystems.newFileSystem(tmpArchiveUri, env);){
                    Path tmpArchiveRootPath = tmpArchiveFs.getPath("/", new String[0]);
                    this.saveContent(api, tmpArchiveRootPath, tmpArchiveRootPath, entry, getProgressFunction, setProgressFunction, isCancelledFunction);
                }
                Files.move(tmpFile.toPath(), path, new CopyOption[0]);
            }
            catch (Exception e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block10;
                throw new AssertionError();
            }
        }
    }
}

