/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.sourcesaver;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.service.sourcesaver.AbstractSourceSaverProvider;
import org.jd.gui.util.ProgressUtil;

public class FileSourceSaverProvider
extends AbstractSourceSaverProvider {
    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:*");
    }

    @Override
    public String getSourcePath(Container.Entry entry) {
        return entry.getPath();
    }

    @Override
    public int getFileCount(API api, Container.Entry entry) {
        return 1;
    }

    @Override
    public void save(API api, Path rootPath, Container.Entry entry, DoubleSupplier getProgressFunction, DoubleConsumer setProgressFunction, BooleanSupplier isCancelledFunction) {
        this.saveContent(api, rootPath, rootPath.resolve(entry.getPath()), entry, getProgressFunction, setProgressFunction, isCancelledFunction);
    }

    @Override
    public void saveContent(API api, Path rootPath, Path path, Container.Entry entry, DoubleSupplier getProgressFunction, DoubleConsumer setProgressFunction, BooleanSupplier isCancelledFunction) {
        block20: {
            block19: {
                try (InputStream is = entry.getInputStream();){
                    Files.copy(is, path, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    assert (ExceptionUtil.printStackTrace((Throwable)e));
                    try (BufferedWriter writer = Files.newBufferedWriter(path, Charset.defaultCharset(), new OpenOption[0]);){
                        writer.write("// INTERNAL ERROR //");
                    }
                    catch (IOException ee) {
                        if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)ee)) break block19;
                        throw new AssertionError();
                    }
                }
            }
            try {
                ProgressUtil.updateProgress(entry, getProgressFunction, setProgressFunction);
            }
            catch (IOException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block20;
                throw new AssertionError();
            }
        }
    }
}

