/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.sourcesaver;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.service.sourcesaver.AbstractSourceSaverProvider;
import org.jd.gui.spi.SourceSaver;

public class DirectorySourceSaverProvider
extends AbstractSourceSaverProvider {
    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:dir:*");
    }

    @Override
    public String getSourcePath(Container.Entry entry) {
        File file = new File(entry.getUri());
        Pattern jarPattern = Pattern.compile("\\.jar$");
        Matcher jarMatcher = jarPattern.matcher(file.getAbsolutePath());
        if (jarMatcher.find()) {
            return jarMatcher.replaceFirst("-sources.jar");
        }
        return entry.getPath() + ".src.zip";
    }

    @Override
    public int getFileCount(API api, Container.Entry entry) {
        return this.getFileCount(api, entry.getChildren().values());
    }

    protected int getFileCount(API api, Collection<Container.Entry> entries) {
        int count = 0;
        for (Container.Entry e : entries) {
            SourceSaver sourceSaver = api.getSourceSaver(e);
            if (sourceSaver == null) continue;
            count += sourceSaver.getFileCount(api, e);
        }
        return count;
    }

    @Override
    public void save(API api, Path rootPath, Container.Entry entry, DoubleSupplier getProgressFunction, DoubleConsumer setProgressFunction, BooleanSupplier isCancelledFunction) {
        block2: {
            Path path = rootPath.resolve(entry.getPath());
            try {
                Files.createDirectories(path, new FileAttribute[0]);
                this.saveContent(api, rootPath, path, entry, getProgressFunction, setProgressFunction, isCancelledFunction);
            }
            catch (IOException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block2;
                throw new AssertionError();
            }
        }
    }

    @Override
    public void saveContent(API api, Path rootPath, Path path, Container.Entry entry, DoubleSupplier getProgressFunction, DoubleConsumer setProgressFunction, BooleanSupplier isCancelledFunction) {
        for (Container.Entry e : this.getChildren(entry)) {
            if (isCancelledFunction.getAsBoolean()) break;
            SourceSaver sourceSaver = api.getSourceSaver(e);
            if (sourceSaver == null) continue;
            sourceSaver.save(api, rootPath, e, getProgressFunction, setProgressFunction, isCancelledFunction);
        }
    }

    protected Collection<Container.Entry> getChildren(Container.Entry entry) {
        return entry.getChildren().values();
    }
}

