/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.sourcesaver;

import com.heliosdecompiler.transformerapi.StandardTransformers;
import com.heliosdecompiler.transformerapi.common.Loader;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import jd.core.ClassUtil;
import jd.core.DecompilationResult;
import org.jd.core.v1.printer.LineNumberStringBuilderPrinter;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.service.sourcesaver.AbstractSourceSaverProvider;
import org.jd.gui.util.MethodPatcher;
import org.jd.gui.util.ProgressUtil;
import org.jd.gui.util.decompiler.ContainerLoader;
import org.jd.gui.util.loader.LoaderUtils;

public class ClassFileSourceSaverProvider
extends AbstractSourceSaverProvider {
    private static final String INTERNAL_ERROR = "// INTERNAL ERROR //";
    protected ContainerLoader loader = new ContainerLoader();
    protected LineNumberStringBuilderPrinter printer = new LineNumberStringBuilderPrinter();

    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:*.class");
    }

    @Override
    public String getSourcePath(Container.Entry entry) {
        String path = entry.getPath();
        int index = path.lastIndexOf(46);
        String prefix = index == -1 ? path : path.substring(0, index);
        return prefix + ".java";
    }

    @Override
    public int getFileCount(API api, Container.Entry entry) {
        if (entry.getPath().indexOf(36) == -1) {
            return 1;
        }
        return 0;
    }

    @Override
    public void save(API api, Path rootPath, Container.Entry entry, DoubleSupplier getProgressFunction, DoubleConsumer setProgressFunction, BooleanSupplier isCancelledFunction) {
        String sourcePath = this.getSourcePath(entry);
        Path path = rootPath.resolve(sourcePath);
        this.saveContent(api, rootPath, path, entry, getProgressFunction, setProgressFunction, isCancelledFunction);
    }

    @Override
    public void saveContent(API api, Path rootPath, Path path, Container.Entry entry, DoubleSupplier getProgressFunction, DoubleConsumer setProgressFunction, BooleanSupplier isCancelledFunction) {
        block7: {
            DecompilationResult decompiledResult;
            block6: {
                decompiledResult = new DecompilationResult();
                try {
                    Map<String, String> preferences = api.getPreferences();
                    this.loader.setEntry(entry);
                    String entryInternalName = ClassUtil.getInternalName((String)entry.getPath());
                    String decompileEngine = preferences.getOrDefault("ClassFileDecompilerPreferences.decompileEngine", "JD-Core v1");
                    Loader apiLoader = LoaderUtils.createLoader(preferences, this.loader, entry);
                    decompiledResult = StandardTransformers.decompile((Loader)apiLoader, (String)entryInternalName, preferences, (String)decompileEngine);
                    if (decompiledResult.getDecompiledOutput().contains("Decompilation failed at line #")) {
                        DecompilationResult sourceCodeV0 = StandardTransformers.decompile((Loader)apiLoader, (String)entryInternalName, preferences, (String)"JD-Core v0");
                        decompiledResult.setDecompiledOutput(MethodPatcher.patchCode(decompiledResult.getDecompiledOutput(), sourceCodeV0.getDecompiledOutput(), entry));
                    }
                }
                catch (Exception t) {
                    decompiledResult.setDecompiledOutput(INTERNAL_ERROR);
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)t)) break block6;
                    throw new AssertionError();
                }
            }
            ClassFileSourceSaverProvider.writeCodeToFile(path, decompiledResult.getDecompiledOutput());
            try {
                ProgressUtil.updateProgress(entry, getProgressFunction, setProgressFunction);
                String internalTypeName = ClassUtil.getInternalName((String)entry.getPath());
                for (Container.Entry e : entry.getParent().getChildren().values()) {
                    if (!e.getPath().startsWith(internalTypeName + "$")) continue;
                    ProgressUtil.updateProgress(e, getProgressFunction, setProgressFunction);
                }
            }
            catch (IOException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block7;
                throw new AssertionError();
            }
        }
    }

    private static void writeCodeToFile(Path path, String sourceCode) {
        block8: {
            try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
                os.write(sourceCode.getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block8;
                throw new AssertionError();
            }
        }
    }
}

