/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.sourcesaver;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.spi.SourceSaver;

public abstract class AbstractSourceSaverProvider
implements SourceSaver {
    private List<String> externalSelectors;
    private Pattern externalPathPattern;

    protected AbstractSourceSaverProvider() {
        Properties properties;
        block9: {
            properties = new Properties();
            try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.getClass().getName().replace('.', '/') + ".properties");){
                if (is != null) {
                    properties.load(is);
                }
            }
            catch (IOException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block9;
                throw new AssertionError();
            }
        }
        this.init(properties);
    }

    protected void init(Properties properties) {
        String pathRegExp;
        String selectors = properties.getProperty("selectors");
        if (selectors != null) {
            this.externalSelectors = Arrays.asList(selectors.split(","));
        }
        if ((pathRegExp = properties.getProperty("pathRegExp")) != null) {
            this.externalPathPattern = Pattern.compile(pathRegExp);
        }
    }

    protected String[] appendSelectors(String selector) {
        if (this.externalSelectors == null) {
            return new String[]{selector};
        }
        int size = this.externalSelectors.size();
        String[] array = new String[size + 1];
        this.externalSelectors.toArray(array);
        array[size] = selector;
        return array;
    }

    protected String[] appendSelectors(String ... selectors) {
        if (this.externalSelectors == null) {
            return selectors;
        }
        int size = this.externalSelectors.size();
        String[] array = new String[size + selectors.length];
        this.externalSelectors.toArray(array);
        System.arraycopy(selectors, 0, array, size, selectors.length);
        return array;
    }

    @Override
    public Pattern getPathPattern() {
        return this.externalPathPattern;
    }
}

