/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.sourceloader;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.IOUtils;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.service.sourceloader.Artifact;
import org.jd.gui.spi.SourceLoader;
import org.jd.gui.util.TempFile;
import org.jd.util.SHA1Util;

public class MavenOrgSourceLoaderProvider
implements SourceLoader {
    protected static final String MAVENORG_SEARCH_URL_PREFIX = "https://search.maven.org/solrsearch/select?q=1:%22";
    protected static final String MAVENORG_SEARCH_URL_SUFFIX = "%22&rows=20&wt=xml";
    protected static final String MAVENORG_LOAD_URL_PREFIX = "https://search.maven.org/classic/remotecontent?filepath=";
    protected static final String MAVENORG_LOAD_URL_SUFFIX = "-sources.jar";
    protected Set<Container.Entry> failed = new HashSet<Container.Entry>();
    protected Map<Container.Entry, File> cache = new HashMap<Container.Entry, File>();

    @Override
    public String getSource(API api, Container.Entry entry) {
        if (MavenOrgSourceLoaderProvider.isActivated(api)) {
            String filters = api.getPreferences().get("MavenOrgSourceLoaderPreferencesProvider.filters");
            if (filters == null || filters.isEmpty()) {
                filters = "+org +com.google +com.springsource +com.sun -com +java +javax +sun +sunw +spring +springframework +springmodules +tomcat +maven +edu";
            }
            if (this.accepted(filters, entry.getPath())) {
                return this.searchSource(entry, this.cache.get(entry.getContainer().getRoot().getParent()));
            }
        }
        return null;
    }

    @Override
    public String loadSource(API api, Container.Entry entry) {
        if (MavenOrgSourceLoaderProvider.isActivated(api)) {
            String filters = api.getPreferences().get("MavenOrgSourceLoaderPreferencesProvider.filters");
            if (filters == null || filters.isEmpty()) {
                filters = "+org +com.google +com.springsource +com.sun -com +java +javax +sun +sunw +spring +springframework +springmodules +tomcat +maven +edu";
            }
            if (this.accepted(filters, entry.getPath())) {
                return this.searchSource(entry, this.downloadSourceJarFile(entry.getContainer().getRoot().getParent()));
            }
        }
        return null;
    }

    @Override
    public File loadSourceFile(API api, Container.Entry entry) {
        return MavenOrgSourceLoaderProvider.isActivated(api) ? this.downloadSourceJarFile(entry) : null;
    }

    private static boolean isActivated(API api) {
        return !"false".equals(api.getPreferences().get("MavenOrgSourceLoaderPreferencesProvider.activated"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String searchSource(Container.Entry entry, File sourceJarFile) {
        if (sourceJarFile == null) return null;
        try (ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(sourceJarFile)));){
            ZipEntry ze = zis.getNextEntry();
            Object name = entry.getPath();
            name = ((String)name).substring(0, ((String)name).length() - 6) + ".java";
            while (ze != null) {
                if (ze.getName().equals(name)) {
                    String string = IOUtils.toString((InputStream)zis, (Charset)StandardCharsets.UTF_8);
                    return string;
                }
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
            return null;
        }
        catch (IOException e) {
            if ($assertionsDisabled) return null;
            if (ExceptionUtil.printStackTrace((Throwable)e)) return null;
            throw new AssertionError();
        }
    }

    /*
     * Loose catch block
     */
    protected File downloadSourceJarFile(Container.Entry entry) {
        block19: {
            if (this.cache.containsKey(entry)) {
                return this.cache.get(entry);
            }
            if (!entry.isDirectory() && !this.failed.contains(entry)) {
                File file = new File(entry.getUri());
                String sha1 = SHA1Util.computeSHA1(file);
                Artifact artifact = MavenOrgSourceLoaderProvider.buildArtifactFromURI(file, sha1);
                if (artifact == null || !artifact.sourceAvailable()) break block19;
                String groupId = artifact.groupId();
                String artifactId = artifact.artifactId();
                String version = artifact.version();
                String filePath = groupId.replace('.', '/') + "/" + artifactId + "/" + version + "/" + artifactId + "-" + version;
                URL loadUrl = new URL(MAVENORG_LOAD_URL_PREFIX + filePath + MAVENORG_LOAD_URL_SUFFIX);
                TempFile tmpFile = new TempFile("." + groupId + "_" + artifactId + "_" + version + MAVENORG_LOAD_URL_SUFFIX);
                BufferedInputStream is = new BufferedInputStream(loadUrl.openStream());
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tmpFile));
                IOUtils.copy((InputStream)is, (OutputStream)os);
                this.cache.put(entry, tmpFile);
                TempFile tempFile = tmpFile;
                ((OutputStream)os).close();
                ((InputStream)is).close();
                tmpFile.close();
                return tempFile;
                {
                    catch (Throwable throwable) {
                        try {
                            try {
                                try {
                                    try {
                                        ((OutputStream)os).close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                                catch (Throwable throwable3) {
                                    try {
                                        ((InputStream)is).close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable3.addSuppressed(throwable4);
                                    }
                                    throw throwable3;
                                }
                            }
                            catch (Throwable throwable5) {
                                try {
                                    tmpFile.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable5.addSuppressed(throwable6);
                                }
                                throw throwable5;
                            }
                        }
                        catch (Exception e) {
                            if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block19;
                            throw new AssertionError();
                        }
                    }
                }
            }
        }
        this.failed.add(entry);
        return null;
    }

    public static Artifact buildArtifactFromURI(File file, String sha1) {
        try {
            URL searchUrl = new URL(MAVENORG_SEARCH_URL_PREFIX + sha1 + MAVENORG_SEARCH_URL_SUFFIX);
            boolean sourceAvailable = false;
            String id = null;
            int numFound = 0;
            try (InputStream is = searchUrl.openStream();){
                XMLInputFactory factory = XMLInputFactory.newInstance();
                factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                XMLStreamReader reader = factory.createXMLStreamReader(is);
                String name = "";
                while (reader.hasNext()) {
                    int next = reader.next();
                    if (next == 1) {
                        if ("str".equals(reader.getLocalName())) {
                            if ("id".equals(reader.getAttributeValue(null, "name"))) {
                                name = "id";
                                continue;
                            }
                            name = "str";
                            continue;
                        }
                        if ("result".equals(reader.getLocalName())) {
                            numFound = Integer.parseInt(reader.getAttributeValue(null, "numFound"));
                            continue;
                        }
                        name = "";
                        continue;
                    }
                    if (next != 4) continue;
                    if ("id".equals(name)) {
                        id = reader.getText().trim();
                        continue;
                    }
                    if (!"str".equals(name)) continue;
                    sourceAvailable |= MAVENORG_LOAD_URL_SUFFIX.equals(reader.getText().trim());
                }
                reader.close();
            }
            Artifact artifact = null;
            boolean found = false;
            if (numFound == 0 && file.exists()) {
                Properties pomProperties = MavenOrgSourceLoaderProvider.getPomProperties(file);
                if (pomProperties != null) {
                    String groupId = pomProperties.getProperty("groupId");
                    String artifactId = pomProperties.getProperty("artifactId");
                    String version = pomProperties.getProperty("version");
                    boolean sourceMightBeAvailable = true;
                    artifact = new Artifact(groupId, artifactId, version, file.getName(), found, sourceMightBeAvailable);
                }
            } else if (id != null) {
                int index1 = id.indexOf(58);
                int index2 = id.lastIndexOf(58);
                String groupId = id.substring(0, index1);
                String artifactId = id.substring(index1 + 1, index2);
                String version = id.substring(index2 + 1);
                found = MavenOrgSourceLoaderProvider.findPom(groupId, artifactId, version);
                artifact = new Artifact(groupId, artifactId, version, file.getName(), found, sourceAvailable);
            }
            return artifact;
        }
        catch (Exception e) {
            assert (ExceptionUtil.printStackTrace((Throwable)e));
            return null;
        }
    }

    private static boolean findPom(String groupId, String artifactId, String version) throws IOException {
        StringBuilder url = new StringBuilder();
        url.append("https://search.maven.org/remotecontent?filepath=");
        url.append(groupId.replace('.', '/'));
        url.append('/');
        url.append(artifactId);
        url.append('/');
        url.append(version);
        url.append('/');
        url.append(artifactId);
        url.append('-');
        url.append(version);
        url.append(".pom");
        HttpURLConnection conn = (HttpURLConnection)new URL(url.toString()).openConnection();
        int responseCode = conn.getResponseCode();
        return responseCode == 200;
    }

    /*
     * Exception decompiling
     */
    private static Properties getPomProperties(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean accepted(String filters, String path) {
        StringTokenizer tokenizer = new StringTokenizer(filters);
        while (tokenizer.hasMoreTokens()) {
            String filter = tokenizer.nextToken();
            if (filter.length() <= 1) continue;
            Object prefix = filter.substring(1).replace('.', '/');
            if (((String)prefix).charAt(((String)prefix).length() - 1) != '/') {
                prefix = (String)prefix + "/";
            }
            if (!path.startsWith((String)prefix)) continue;
            return filter.charAt(0) == '+';
        }
        return false;
    }
}

