/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.preferencespanel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.spi.PreferencesPanel;

public class ViewerPreferencesProvider
extends JPanel
implements PreferencesPanel,
DocumentListener {
    private static final long serialVersionUID = 1L;
    protected static final int MIN_VALUE = 2;
    protected static final int MAX_VALUE = 40;
    protected transient PreferencesPanel.PreferencesPanelChangeListener listener;
    protected JTextField fontSizeTextField;
    protected Color errorBackgroundColor = Color.RED;
    protected Color defaultBackgroundColor;

    public ViewerPreferencesProvider() {
        super(new BorderLayout());
        this.add((Component)new JLabel("Font size (2..40): "), "West");
        this.fontSizeTextField = new JTextField();
        this.fontSizeTextField.getDocument().addDocumentListener(this);
        this.add((Component)this.fontSizeTextField, "Center");
        this.defaultBackgroundColor = this.fontSizeTextField.getBackground();
    }

    @Override
    public String getPreferencesGroupTitle() {
        return "Viewer";
    }

    @Override
    public String getPreferencesPanelTitle() {
        return "Appearance";
    }

    @Override
    public JComponent getPanel() {
        return this;
    }

    @Override
    public void init(Color errorBackgroundColor) {
        this.errorBackgroundColor = errorBackgroundColor;
    }

    @Override
    public boolean isActivated() {
        return true;
    }

    @Override
    public void loadPreferences(Map<String, String> preferences) {
        String fontSize = preferences.get("ViewerPreferences.fontSize");
        if (fontSize == null) {
            RSyntaxTextArea textArea;
            block9: {
                textArea = new RSyntaxTextArea();
                try (InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("rsyntaxtextarea/themes/eclipse.xml");){
                    Theme theme = Theme.load((InputStream)resourceAsStream);
                    theme.apply(textArea);
                }
                catch (IOException e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block9;
                    throw new AssertionError();
                }
            }
            fontSize = String.valueOf(textArea.getFont().getSize());
        }
        this.fontSizeTextField.setText(fontSize);
        this.fontSizeTextField.setCaretPosition(this.fontSizeTextField.getText().length());
    }

    @Override
    public void savePreferences(Map<String, String> preferences) {
        preferences.put("ViewerPreferences.fontSize", this.fontSizeTextField.getText());
    }

    @Override
    public boolean arePreferencesValid() {
        block3: {
            try {
                String fontSize = this.fontSizeTextField.getText();
                if (fontSize != null && fontSize.matches("\\d+")) {
                    int i = Integer.parseInt(fontSize);
                    return i >= 2 && i <= 40;
                }
            }
            catch (NumberFormatException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block3;
                throw new AssertionError();
            }
        }
        return false;
    }

    @Override
    public void addPreferencesChangeListener(PreferencesPanel.PreferencesPanelChangeListener listener) {
        this.listener = listener;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.onTextChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.onTextChange();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.onTextChange();
    }

    public void onTextChange() {
        this.fontSizeTextField.setBackground(this.arePreferencesValid() ? this.defaultBackgroundColor : this.errorBackgroundColor);
        if (this.listener != null) {
            this.listener.preferencesPanelChanged(this);
        }
    }

    @Override
    public void restoreDefaults() {
        this.fontSizeTextField.setText("12");
    }
}

