/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.preferencespanel;

import jadx.api.JadxArgs;
import java.awt.Color;
import java.awt.GridLayout;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.spi.PreferencesPanel;

public class JadxDecompilerPreferencesProvider
extends JPanel
implements PreferencesPanel {
    private static final long serialVersionUID = 1L;
    private static final Class<?>[] BOOLEAN_PARAM = new Class[]{Boolean.TYPE};
    private static final Class<?>[] INT_PARAM = new Class[]{Integer.TYPE};
    private Map<String, JComponent> components = new HashMap<String, JComponent>();
    private Map<String, String> defaults = new HashMap<String, String>();

    public JadxDecompilerPreferencesProvider() {
        super(new GridLayout(0, 4));
        JadxArgs defaultOptions = new JadxArgs();
        Method[] methods = JadxArgs.class.getMethods();
        Arrays.sort(methods, Comparator.comparing(Method::getName));
        for (Method method : methods) {
            if (!method.getName().startsWith("set")) continue;
            String optionKey = method.getName().substring(3);
            try {
                JComponent component = null;
                if (Arrays.equals(method.getParameterTypes(), BOOLEAN_PARAM)) {
                    getter = JadxArgs.class.getMethod("is" + optionKey, new Class[0]);
                    defaultValue = (Boolean)getter.invoke((Object)defaultOptions, new Object[0]);
                    component = new JCheckBox();
                    this.defaults.put(optionKey, Boolean.toString((Boolean)defaultValue));
                } else if (Arrays.equals(method.getParameterTypes(), INT_PARAM)) {
                    getter = JadxArgs.class.getMethod("get" + optionKey, new Class[0]);
                    defaultValue = (Integer)getter.invoke((Object)defaultOptions, new Object[0]);
                    component = new JTextField();
                    this.defaults.put(optionKey, Integer.toString((Integer)defaultValue));
                }
                if (component == null) continue;
                JLabel label = new JLabel(optionKey);
                label.setLabelFor(component);
                label.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
                this.components.put(optionKey, component);
                this.add(label);
                this.add(component);
            }
            catch (Exception e) {
                assert (ExceptionUtil.printStackTrace((Throwable)e));
            }
        }
    }

    @Override
    public void restoreDefaults() {
        for (Map.Entry<String, String> defaultEntry : this.defaults.entrySet()) {
            String componentKey = defaultEntry.getKey();
            String defaultValue = defaultEntry.getValue();
            JComponent component = this.components.get(componentKey);
            if (component == null) continue;
            if (component instanceof JCheckBox) {
                ((JCheckBox)component).setSelected("true".equals(defaultValue));
                continue;
            }
            if (!(component instanceof JTextField)) continue;
            ((JTextField)component).setText(defaultValue);
        }
    }

    @Override
    public String getPreferencesGroupTitle() {
        return "Decompiler";
    }

    @Override
    public String getPreferencesPanelTitle() {
        return "Class file";
    }

    @Override
    public JComponent getPanel() {
        return this;
    }

    @Override
    public void init(Color errorBackgroundColor) {
    }

    @Override
    public boolean isActivated() {
        return true;
    }

    @Override
    public void loadPreferences(Map<String, String> preferences) {
        for (Map.Entry<String, String> preference : preferences.entrySet()) {
            String preferenceKey = preference.getKey();
            String preferenceValue = preference.getValue();
            JComponent component = this.components.get(preferenceKey);
            if (preferenceValue != null) {
                if (component instanceof JCheckBox) {
                    ((JCheckBox)component).setSelected("true".equals(preferenceValue));
                    continue;
                }
                if (!(component instanceof JTextField)) continue;
                ((JTextField)component).setText(preferenceValue);
                continue;
            }
            if (component instanceof JCheckBox) {
                ((JCheckBox)component).setSelected("true".equals(this.defaults.get(preferenceKey)));
                continue;
            }
            if (!(component instanceof JTextField)) continue;
            ((JTextField)component).setText(this.defaults.getOrDefault(preferenceKey, ""));
        }
    }

    @Override
    public void savePreferences(Map<String, String> preferences) {
        for (Map.Entry<String, JComponent> componentEntry : this.components.entrySet()) {
            String componentKey = componentEntry.getKey();
            JComponent component = componentEntry.getValue();
            if (component instanceof JCheckBox) {
                preferences.put(componentKey, Boolean.toString(((JCheckBox)component).isSelected()));
                continue;
            }
            if (!(component instanceof JTextField)) continue;
            String text = ((JTextField)component).getText();
            if (text.isEmpty()) {
                preferences.remove(componentKey);
                continue;
            }
            preferences.put(componentKey, text);
        }
    }

    @Override
    public boolean arePreferencesValid() {
        return true;
    }

    @Override
    public void addPreferencesChangeListener(PreferencesPanel.PreferencesPanelChangeListener listener) {
    }
}

