/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.preferencespanel;

import java.awt.Color;
import java.awt.GridLayout;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jd.gui.spi.PreferencesPanel;

public class JDCoreDecompilerPreferencesProvider
extends JPanel
implements PreferencesPanel {
    private static final long serialVersionUID = 1L;
    protected JCheckBox writeLineNumbersCheckBox;
    protected JCheckBox writeMetadataCheckBox;
    protected JCheckBox escapeUnicodeCharactersCheckBox;
    protected JCheckBox realignLineNumbersCheckBox;
    protected JCheckBox omitThisPrefixCheckBox;
    protected JCheckBox displayDefaultConstructorCheckBox;
    protected JComboBox<String> decompileEngine;

    public JDCoreDecompilerPreferencesProvider(JComboBox<String> decompileEngine) {
        super(new GridLayout(0, 2));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.decompileEngine = decompileEngine;
        this.writeLineNumbersCheckBox = new JCheckBox("Write original line numbers");
        this.writeMetadataCheckBox = new JCheckBox("Write metadata");
        this.escapeUnicodeCharactersCheckBox = new JCheckBox("Escape unicode characters");
        this.realignLineNumbersCheckBox = new JCheckBox("Realign line numbers");
        this.omitThisPrefixCheckBox = new JCheckBox("Omit the prefix 'this' if possible");
        this.displayDefaultConstructorCheckBox = new JCheckBox("Display default constructor");
        this.add(this.writeLineNumbersCheckBox);
        this.add(this.writeMetadataCheckBox);
        this.add(this.escapeUnicodeCharactersCheckBox);
        this.add(this.realignLineNumbersCheckBox);
        this.add(this.omitThisPrefixCheckBox);
        this.add(this.displayDefaultConstructorCheckBox);
    }

    @Override
    public void restoreDefaults() {
        this.writeLineNumbersCheckBox.setSelected(true);
        this.writeMetadataCheckBox.setSelected(true);
        this.escapeUnicodeCharactersCheckBox.setSelected(false);
        this.realignLineNumbersCheckBox.setSelected(false);
        this.omitThisPrefixCheckBox.setSelected(false);
        this.displayDefaultConstructorCheckBox.setSelected(false);
    }

    @Override
    public void loadPreferences(Map<String, String> preferences) {
        this.writeLineNumbersCheckBox.setSelected(Boolean.parseBoolean(preferences.getOrDefault("ClassFileSaverPreferences.writeLineNumbers", Boolean.TRUE.toString())));
        this.writeMetadataCheckBox.setSelected(Boolean.parseBoolean(preferences.getOrDefault("ClassFileSaverPreferences.writeMetadata", Boolean.TRUE.toString())));
        this.escapeUnicodeCharactersCheckBox.setSelected(Boolean.parseBoolean(preferences.getOrDefault("ClassFileSaverPreferences.escapeUnicodeCharacters", Boolean.FALSE.toString())));
        this.realignLineNumbersCheckBox.setSelected(Boolean.parseBoolean(preferences.getOrDefault("ClassFileSaverPreferences.realignLineNumbers", Boolean.FALSE.toString())));
        this.omitThisPrefixCheckBox.setSelected(Boolean.parseBoolean(preferences.getOrDefault("ClassFileSaverPreferences.omitThisPrefix", Boolean.FALSE.toString())));
        this.displayDefaultConstructorCheckBox.setSelected(Boolean.parseBoolean(preferences.getOrDefault("ClassFileViewerPreferences.displayDefaultConstructor", Boolean.FALSE.toString())));
        this.toggleOldOptions();
    }

    @Override
    public void savePreferences(Map<String, String> preferences) {
        preferences.put("ClassFileSaverPreferences.writeLineNumbers", Boolean.toString(this.writeLineNumbersCheckBox.isSelected()));
        preferences.put("ClassFileSaverPreferences.writeMetadata", Boolean.toString(this.writeMetadataCheckBox.isSelected()));
        preferences.put("ClassFileSaverPreferences.escapeUnicodeCharacters", Boolean.toString(this.escapeUnicodeCharactersCheckBox.isSelected()));
        preferences.put("ClassFileSaverPreferences.realignLineNumbers", Boolean.toString(this.realignLineNumbersCheckBox.isSelected()));
        preferences.put("ClassFileSaverPreferences.omitThisPrefix", Boolean.toString(this.omitThisPrefixCheckBox.isSelected()));
        preferences.put("ClassFileViewerPreferences.displayDefaultConstructor", Boolean.toString(this.displayDefaultConstructorCheckBox.isSelected()));
    }

    @Override
    public String getPreferencesGroupTitle() {
        return "Decompiler";
    }

    @Override
    public String getPreferencesPanelTitle() {
        return "Class file";
    }

    @Override
    public JComponent getPanel() {
        return this;
    }

    @Override
    public void init(Color errorBackgroundColor) {
    }

    @Override
    public boolean isActivated() {
        return true;
    }

    @Override
    public boolean arePreferencesValid() {
        return true;
    }

    @Override
    public void addPreferencesChangeListener(PreferencesPanel.PreferencesPanelChangeListener listener) {
    }

    public void toggleOldOptions() {
        this.omitThisPrefixCheckBox.setEnabled("JD-Core v0".equals(this.decompileEngine.getSelectedItem()));
        this.displayDefaultConstructorCheckBox.setEnabled("JD-Core v0".equals(this.decompileEngine.getSelectedItem()));
    }
}

