/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.preferencespanel;

import com.strobel.reflection.FieldInfo;
import com.strobel.reflection.Type;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jd.gui.spi.PreferencesPanel;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IFernflowerPreferences;

public class FernflowerDecompilerPreferencesProvider
extends JPanel
implements PreferencesPanel {
    private static final long serialVersionUID = 1L;
    private static final String TRUE = "1";
    private static final String FALSE = "0";
    private static final String[] LOG_LEVELS = (String[])EnumSet.allOf(IFernflowerLogger.Severity.class).stream().map(Enum::name).toArray(String[]::new);
    private static final Dimension FIELD_DIMENSION = new Dimension(250, 20);
    private Map<String, JComponent> components = new HashMap<String, JComponent>();

    public FernflowerDecompilerPreferencesProvider() {
        super(new GridLayout(0, 4));
        for (FieldInfo fieldInfo : Type.of(IFernflowerPreferences.class).getFields()) {
            JComponent component;
            String trigram;
            if (!String.class.getName().equals(fieldInfo.getFieldType().getTypeName()) || !(trigram = (String)fieldInfo.getValue(null)).matches("\\w{3}")) continue;
            Object defaultValue = IFernflowerPreferences.DEFAULTS.get(trigram);
            if (!"mpm".equals(trigram) && (FALSE.equals(defaultValue) || TRUE.equals(defaultValue))) {
                component = new JCheckBox();
            } else if ("log".equals(trigram)) {
                component = new JComboBox<String>(LOG_LEVELS);
            } else {
                component = new JTextField();
                component.setMinimumSize(FIELD_DIMENSION);
                component.setMaximumSize(FIELD_DIMENSION);
                component.setPreferredSize(FIELD_DIMENSION);
            }
            this.components.put(trigram, component);
            JLabel label = new JLabel(fieldInfo.getName() + " (" + trigram + ")");
            label.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            this.add(label);
            this.add(component);
        }
    }

    @Override
    public void restoreDefaults() {
        for (Map.Entry defaultEntry : IFernflowerPreferences.DEFAULTS.entrySet()) {
            String componentKey = (String)defaultEntry.getKey();
            Object defaultValue = defaultEntry.getValue();
            JComponent component = this.components.get(componentKey);
            if (component instanceof JComboBox) {
                ((JComboBox)component).setSelectedItem(defaultValue);
                continue;
            }
            if (component instanceof JCheckBox) {
                ((JCheckBox)component).setSelected(TRUE.equals(defaultValue));
                continue;
            }
            if (!(component instanceof JTextField)) continue;
            ((JTextField)component).setText(defaultValue.toString());
        }
    }

    @Override
    public String getPreferencesGroupTitle() {
        return "Decompiler";
    }

    @Override
    public String getPreferencesPanelTitle() {
        return "Class file";
    }

    @Override
    public JComponent getPanel() {
        return this;
    }

    @Override
    public void init(Color errorBackgroundColor) {
    }

    @Override
    public boolean isActivated() {
        return true;
    }

    @Override
    public void loadPreferences(Map<String, String> preferences) {
        for (Map.Entry<String, String> preference : preferences.entrySet()) {
            String preferenceKey = preference.getKey();
            String preferenceValue = preference.getValue();
            JComponent component = this.components.get(preferenceKey);
            if (preferenceValue != null) {
                if (component instanceof JComboBox) {
                    ((JComboBox)component).setSelectedItem(preferenceValue);
                    continue;
                }
                if (component instanceof JCheckBox) {
                    ((JCheckBox)component).setSelected(TRUE.equals(preferenceValue));
                    continue;
                }
                if (!(component instanceof JTextField)) continue;
                ((JTextField)component).setText(preferenceValue);
                continue;
            }
            if (component instanceof JComboBox) {
                ((JComboBox)component).setSelectedItem(IFernflowerPreferences.DEFAULTS.get(preferenceKey));
                continue;
            }
            if (component instanceof JCheckBox) {
                ((JCheckBox)component).setSelected(TRUE.equals(IFernflowerPreferences.DEFAULTS.get(preferenceKey)));
                continue;
            }
            if (!(component instanceof JTextField)) continue;
            ((JTextField)component).setText(IFernflowerPreferences.DEFAULTS.getOrDefault(preferenceKey, "").toString());
        }
    }

    @Override
    public void savePreferences(Map<String, String> preferences) {
        for (Map.Entry<String, JComponent> componentEntry : this.components.entrySet()) {
            String componentKey = componentEntry.getKey();
            JComponent component = componentEntry.getValue();
            if (component instanceof JComboBox) {
                JComboBox comboBox = (JComboBox)component;
                preferences.put(componentKey, comboBox.getSelectedItem().toString());
                continue;
            }
            if (component instanceof JCheckBox) {
                preferences.put(componentKey, ((JCheckBox)component).isSelected() ? TRUE : FALSE);
                continue;
            }
            if (!(component instanceof JTextField)) continue;
            String text = ((JTextField)component).getText();
            if (text.isEmpty()) {
                preferences.remove(componentKey);
                continue;
            }
            preferences.put(componentKey, text);
        }
    }

    @Override
    public boolean arePreferencesValid() {
        return true;
    }

    @Override
    public void addPreferencesChangeListener(PreferencesPanel.PreferencesPanelChangeListener listener) {
    }
}

