/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.preferencespanel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.spi.PreferencesPanel;

public class DirectoryIndexerPreferencesProvider
extends JPanel
implements PreferencesPanel,
DocumentListener {
    private static final long serialVersionUID = 1L;
    protected static final int MAX_VALUE = 30;
    protected transient PreferencesPanel.PreferencesPanelChangeListener listener;
    protected JTextField maximumDepthTextField;
    protected Color errorBackgroundColor = Color.RED;
    protected Color defaultBackgroundColor;

    public DirectoryIndexerPreferencesProvider() {
        super(new BorderLayout());
        this.add((Component)new JLabel("Maximum depth (1..30): "), "West");
        this.maximumDepthTextField = new JTextField();
        this.maximumDepthTextField.getDocument().addDocumentListener(this);
        this.add((Component)this.maximumDepthTextField, "Center");
        this.defaultBackgroundColor = this.maximumDepthTextField.getBackground();
    }

    @Override
    public String getPreferencesGroupTitle() {
        return "Indexer";
    }

    @Override
    public String getPreferencesPanelTitle() {
        return "Directory exploration";
    }

    @Override
    public JComponent getPanel() {
        return this;
    }

    @Override
    public void init(Color errorBackgroundColor) {
        this.errorBackgroundColor = errorBackgroundColor;
    }

    @Override
    public boolean isActivated() {
        return true;
    }

    @Override
    public void loadPreferences(Map<String, String> preferences) {
        String preference = preferences.get("DirectoryIndexerPreferences.maximumDepth");
        this.maximumDepthTextField.setText(preference != null ? preference : "15");
        this.maximumDepthTextField.setCaretPosition(this.maximumDepthTextField.getText().length());
    }

    @Override
    public void savePreferences(Map<String, String> preferences) {
        preferences.put("DirectoryIndexerPreferences.maximumDepth", this.maximumDepthTextField.getText());
    }

    @Override
    public boolean arePreferencesValid() {
        block3: {
            try {
                String maxDepth = this.maximumDepthTextField.getText();
                if (maxDepth != null && maxDepth.matches("\\d+")) {
                    int i = Integer.parseInt(maxDepth);
                    return i > 0 && i <= 30;
                }
            }
            catch (NumberFormatException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block3;
                throw new AssertionError();
            }
        }
        return false;
    }

    @Override
    public void addPreferencesChangeListener(PreferencesPanel.PreferencesPanelChangeListener listener) {
        this.listener = listener;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.onTextChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.onTextChange();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.onTextChange();
    }

    public void onTextChange() {
        this.maximumDepthTextField.setBackground(this.arePreferencesValid() ? this.defaultBackgroundColor : this.errorBackgroundColor);
        if (this.listener != null) {
            this.listener.preferencesPanelChanged(this);
        }
    }

    @Override
    public void restoreDefaults() {
        this.maximumDepthTextField.setText("15");
    }
}

