/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.preferencespanel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jd.gui.service.preferencespanel.CFRDecompilerPreferencesProvider;
import org.jd.gui.service.preferencespanel.FernflowerDecompilerPreferencesProvider;
import org.jd.gui.service.preferencespanel.JDCoreDecompilerPreferencesProvider;
import org.jd.gui.service.preferencespanel.JadxDecompilerPreferencesProvider;
import org.jd.gui.service.preferencespanel.ProcyonDecompilerPreferencesProvider;
import org.jd.gui.service.preferencespanel.VineflowerDecompilerPreferencesProvider;
import org.jd.gui.spi.PreferencesPanel;
import org.jd.gui.util.ImageUtil;

public class ClassFileDecompilerPreferencesProvider
extends JPanel
implements PreferencesPanel {
    private static final long serialVersionUID = 1L;
    protected JCheckBox showCompilerErrorsCheckBox;
    protected JCheckBox showCompilerWarningsCheckBox;
    protected JCheckBox showCompilerInfoCheckBox;
    protected JCheckBox advancedClassLookupCheckBox;
    protected JCheckBox removeUnnecessaryCastsCheckBox;
    protected JLabel selectDecompiler;
    protected JComboBox<String> decompileEngine;
    protected JButton configureDecompiler;
    private static final String[] DECOMPILERS = new String[]{"JD-Core v1", "JD-Core v0", "CFR", "Procyon", "Fernflower", "Vineflower", "JADX"};
    private transient Map<String, PreferencesPanel> decompilerPreferencesProviders = new HashMap<String, PreferencesPanel>();

    public ClassFileDecompilerPreferencesProvider() {
        super(new GridLayout(0, 2));
        this.showCompilerErrorsCheckBox = new JCheckBox("Show compiler errors");
        this.showCompilerWarningsCheckBox = new JCheckBox("Show compiler warnings");
        this.showCompilerInfoCheckBox = new JCheckBox("Show compiler info");
        this.advancedClassLookupCheckBox = new JCheckBox("Advanced class lookup");
        this.removeUnnecessaryCastsCheckBox = new JCheckBox("Remove unnecessary casts");
        this.selectDecompiler = new JLabel("Select Decompile Engine: ");
        this.decompileEngine = new JComboBox<String>(DECOMPILERS);
        this.configureDecompiler = new JButton("Configure", new ImageIcon(ImageUtil.getImage("/org/jd/gui/images/preferences.png")));
        this.configureDecompiler.addActionListener(e -> this.configureDecompiler());
        this.add(this.advancedClassLookupCheckBox);
        this.add(this.showCompilerErrorsCheckBox);
        this.add(this.removeUnnecessaryCastsCheckBox);
        this.add(this.showCompilerWarningsCheckBox);
        this.add(this.selectDecompiler);
        this.add(this.showCompilerInfoCheckBox);
        this.add(this.decompileEngine);
        this.add(this.configureDecompiler);
        JDCoreDecompilerPreferencesProvider jdCoreDecompilerPreferencesProvider = new JDCoreDecompilerPreferencesProvider(this.decompileEngine);
        this.decompilerPreferencesProviders.put("JD-Core v0", jdCoreDecompilerPreferencesProvider);
        this.decompilerPreferencesProviders.put("JD-Core v1", jdCoreDecompilerPreferencesProvider);
        this.decompilerPreferencesProviders.put("CFR", new CFRDecompilerPreferencesProvider());
        this.decompilerPreferencesProviders.put("Procyon", new ProcyonDecompilerPreferencesProvider());
        this.decompilerPreferencesProviders.put("Fernflower", new FernflowerDecompilerPreferencesProvider());
        this.decompilerPreferencesProviders.put("Vineflower", new VineflowerDecompilerPreferencesProvider());
        this.decompilerPreferencesProviders.put("JADX", new JadxDecompilerPreferencesProvider());
        this.decompileEngine.addActionListener(e -> jdCoreDecompilerPreferencesProvider.toggleOldOptions());
    }

    public void configureDecompiler() {
        String selectedDecompiler = this.decompileEngine.getSelectedItem().toString();
        JDialog optionDialog = new JDialog((JDialog)SwingUtilities.getWindowAncestor(this), selectedDecompiler + " Settings", true);
        optionDialog.setLayout(new BorderLayout());
        JPanel dialogPanel = (JPanel)optionDialog.getContentPane();
        dialogPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel preferencesPanels = (JPanel)((Object)this.decompilerPreferencesProviders.get(selectedDecompiler));
        JScrollPane preferencesScrollPane = new JScrollPane(preferencesPanels);
        preferencesScrollPane.setHorizontalScrollBarPolicy(31);
        preferencesScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        optionDialog.getContentPane().add((Component)preferencesScrollPane, "Center");
        Box vbox = Box.createVerticalBox();
        optionDialog.getContentPane().add((Component)vbox, "South");
        vbox.add(Box.createVerticalStrut(15));
        Box hbox = Box.createHorizontalBox();
        hbox.add(Box.createHorizontalGlue());
        JButton defaultsButton = new JButton("Restore Defaults");
        defaultsButton.addActionListener(e -> ((PreferencesPanel)((Object)preferencesPanels)).restoreDefaults());
        hbox.add(defaultsButton);
        hbox.add(Box.createHorizontalStrut(5));
        JButton okButton = new JButton("OK");
        okButton.addActionListener(e -> optionDialog.dispose());
        hbox.add(okButton);
        hbox.add(Box.createHorizontalGlue());
        vbox.add(hbox);
        optionDialog.setLocationRelativeTo(this);
        optionDialog.pack();
        optionDialog.setVisible(true);
    }

    @Override
    public String getPreferencesGroupTitle() {
        return "Decompiler";
    }

    @Override
    public String getPreferencesPanelTitle() {
        return "Class file";
    }

    @Override
    public JComponent getPanel() {
        return this;
    }

    @Override
    public void init(Color errorBackgroundColor) {
    }

    @Override
    public boolean isActivated() {
        return true;
    }

    @Override
    public void loadPreferences(Map<String, String> preferences) {
        this.showCompilerErrorsCheckBox.setSelected("true".equals(preferences.get("ClassFileDecompilerPreferences.showCompilerErrors")));
        this.showCompilerWarningsCheckBox.setSelected("true".equals(preferences.get("ClassFileDecompilerPreferences.showCompilerWarnings")));
        this.showCompilerInfoCheckBox.setSelected("true".equals(preferences.get("ClassFileDecompilerPreferences.showCompilerInfo")));
        this.advancedClassLookupCheckBox.setSelected("true".equals(preferences.get("ClassFileDecompilerPreferences.advancedClassLookup")));
        this.removeUnnecessaryCastsCheckBox.setSelected("true".equals(preferences.get("ClassFileDecompilerPreferences.removeUnnecessaryCasts")));
        this.decompileEngine.setSelectedItem(preferences.getOrDefault("ClassFileDecompilerPreferences.decompileEngine", "JD-Core v1"));
        for (PreferencesPanel preferencesPanel : this.decompilerPreferencesProviders.values()) {
            preferencesPanel.loadPreferences(preferences);
        }
    }

    @Override
    public void savePreferences(Map<String, String> preferences) {
        preferences.put("ClassFileDecompilerPreferences.showCompilerErrors", Boolean.toString(this.showCompilerErrorsCheckBox.isSelected()));
        preferences.put("ClassFileDecompilerPreferences.showCompilerWarnings", Boolean.toString(this.showCompilerWarningsCheckBox.isSelected()));
        preferences.put("ClassFileDecompilerPreferences.showCompilerInfo", Boolean.toString(this.showCompilerInfoCheckBox.isSelected()));
        preferences.put("ClassFileDecompilerPreferences.advancedClassLookup", Boolean.toString(this.advancedClassLookupCheckBox.isSelected()));
        preferences.put("ClassFileDecompilerPreferences.removeUnnecessaryCasts", Boolean.toString(this.removeUnnecessaryCastsCheckBox.isSelected()));
        preferences.put("ClassFileDecompilerPreferences.decompileEngine", this.decompileEngine.getSelectedItem().toString());
        for (PreferencesPanel preferencesPanel : this.decompilerPreferencesProviders.values()) {
            preferencesPanel.savePreferences(preferences);
        }
    }

    @Override
    public boolean arePreferencesValid() {
        return true;
    }

    @Override
    public void addPreferencesChangeListener(PreferencesPanel.PreferencesPanelChangeListener listener) {
    }

    @Override
    public void restoreDefaults() {
        this.showCompilerErrorsCheckBox.setSelected(false);
        this.showCompilerWarningsCheckBox.setSelected(false);
        this.showCompilerInfoCheckBox.setSelected(false);
        this.advancedClassLookupCheckBox.setSelected(false);
        this.removeUnnecessaryCastsCheckBox.setSelected(false);
        this.decompileEngine.setSelectedItem("JD-Core v1");
    }
}

