/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.preferencespanel;

import com.strobel.reflection.BindingFlags;
import com.strobel.reflection.FieldInfo;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeList;
import java.awt.Color;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.benf.cfr.reader.util.Troolean;
import org.benf.cfr.reader.util.getopt.OptionDecoderParam;
import org.benf.cfr.reader.util.getopt.OptionsImpl;
import org.benf.cfr.reader.util.getopt.PermittedOptionProvider;
import org.jd.gui.spi.PreferencesPanel;

public class CFRDecompilerPreferencesProvider
extends JPanel
implements PreferencesPanel {
    private static final long serialVersionUID = 1L;
    private Map<String, JComponent> components = new HashMap<String, JComponent>();
    private Map<String, String> defaults = new HashMap<String, String>();

    public CFRDecompilerPreferencesProvider() {
        super(new GridLayout(0, 6));
        for (FieldInfo fieldInfo : Type.of(OptionsImpl.class).getFields()) {
            Type fieldType = fieldInfo.getFieldType();
            if (!fieldType.getName().startsWith("Argument")) continue;
            PermittedOptionProvider.ArgumentParam argInstance = (PermittedOptionProvider.ArgumentParam)fieldInfo.getValue(null);
            MethodInfo fnMethod = fieldType.getMethod("getFn", BindingFlags.All, new Type[0]);
            fnMethod.getRawMethod().setAccessible(true);
            OptionDecoderParam optionDecoderParam = (OptionDecoderParam)fnMethod.invoke((Object)argInstance, new Object[0]);
            String defaultValue = optionDecoderParam.getDefaultValue();
            String rangeDescription = optionDecoderParam.getRangeDescription();
            MethodInfo describeMethod = fieldType.getMethod("describe", BindingFlags.All, new Type[0]);
            describeMethod.getRawMethod().setAccessible(true);
            String helpText = (String)describeMethod.invoke((Object)argInstance, new Object[0]);
            String helpTextHTML = "<html>" + helpText.replace("\n", "<br>") + "</html>";
            TypeList typeArguments = fieldType.getTypeArguments();
            Type optionType = (Type)typeArguments.get(0);
            JComponent component = typeArguments.size() == 1 && Boolean.class.getName().equals(optionType.getTypeName()) ? new JCheckBox() : (Troolean.class.getName().equals(optionType.getTypeName()) || typeArguments.size() > 1 && Boolean.class.getName().equals(optionType.getTypeName()) ? new JComboBox<String>(new String[]{"auto", "true", "false"}) : (rangeDescription.startsWith("One of [") && rangeDescription.endsWith("]") ? new JComboBox<String>(rangeDescription.substring(8, rangeDescription.length() - 1).split(", ")) : new JTextField()));
            JLabel label = new JLabel(argInstance.getName());
            label.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            label.setToolTipText(helpTextHTML);
            component.setToolTipText(helpTextHTML);
            this.add(label);
            this.add(component);
            this.components.put(argInstance.getName(), component);
            if (defaultValue != null && defaultValue.matches("\\w+")) {
                this.defaults.put(argInstance.getName(), defaultValue);
                continue;
            }
            if (!(component instanceof JComboBox)) continue;
            this.defaults.put(argInstance.getName(), "auto");
        }
    }

    @Override
    public void restoreDefaults() {
        for (Map.Entry<String, String> defaultEntry : this.defaults.entrySet()) {
            String componentKey = defaultEntry.getKey();
            String defaultValue = defaultEntry.getValue();
            JComponent component = this.components.get(componentKey);
            if (component instanceof JComboBox) {
                ((JComboBox)component).setSelectedItem(defaultValue);
                continue;
            }
            if (component instanceof JCheckBox) {
                ((JCheckBox)component).setSelected("true".equals(defaultValue));
                continue;
            }
            if (!(component instanceof JTextField)) continue;
            ((JTextField)component).setText(defaultValue);
        }
    }

    @Override
    public String getPreferencesGroupTitle() {
        return "Decompiler";
    }

    @Override
    public String getPreferencesPanelTitle() {
        return "Class file";
    }

    @Override
    public JComponent getPanel() {
        return this;
    }

    @Override
    public void init(Color errorBackgroundColor) {
    }

    @Override
    public boolean isActivated() {
        return true;
    }

    @Override
    public void loadPreferences(Map<String, String> preferences) {
        for (Map.Entry<String, String> preference : preferences.entrySet()) {
            String preferenceKey = preference.getKey();
            String preferenceValue = preference.getValue();
            JComponent component = this.components.get(preferenceKey);
            if (preferenceValue != null) {
                if (component instanceof JComboBox) {
                    ((JComboBox)component).setSelectedItem(preferenceValue);
                    continue;
                }
                if (component instanceof JCheckBox) {
                    ((JCheckBox)component).setSelected("true".equals(preferenceValue));
                    continue;
                }
                if (!(component instanceof JTextField)) continue;
                ((JTextField)component).setText(preferenceValue);
                continue;
            }
            if (component instanceof JComboBox) {
                ((JComboBox)component).setSelectedItem(this.defaults.getOrDefault(preferenceKey, "auto"));
                continue;
            }
            if (component instanceof JCheckBox) {
                ((JCheckBox)component).setSelected("true".equals(this.defaults.get(preferenceKey)));
                continue;
            }
            if (!(component instanceof JTextField)) continue;
            ((JTextField)component).setText(this.defaults.getOrDefault(preferenceKey, ""));
        }
    }

    @Override
    public void savePreferences(Map<String, String> preferences) {
        for (Map.Entry<String, JComponent> componentEntry : this.components.entrySet()) {
            String componentKey = componentEntry.getKey();
            JComponent component = componentEntry.getValue();
            if (component instanceof JComboBox) {
                JComboBox comboBox = (JComboBox)component;
                if ("auto".equals(comboBox.getSelectedItem().toString())) {
                    preferences.remove(componentKey);
                    continue;
                }
                preferences.put(componentKey, comboBox.getSelectedItem().toString());
                continue;
            }
            if (component instanceof JCheckBox) {
                preferences.put(componentKey, Boolean.toString(((JCheckBox)component).isSelected()));
                continue;
            }
            if (!(component instanceof JTextField)) continue;
            String text = ((JTextField)component).getText();
            if (text.isEmpty()) {
                preferences.remove(componentKey);
                continue;
            }
            preferences.put(componentKey, text);
        }
    }

    @Override
    public boolean arePreferencesValid() {
        return true;
    }

    @Override
    public void addPreferencesChangeListener(PreferencesPanel.PreferencesPanelChangeListener listener) {
    }
}

