/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.platform;

public class PlatformService {
    protected static final PlatformService PLATFORM_SERVICE = new PlatformService();
    private final OS os;

    protected PlatformService() {
        String osName = System.getProperty("os.name").toLowerCase();
        this.os = osName.contains("windows") ? OS.WINDOWS : (osName.contains("mac os") ? OS.MAC_OSX : OS.LINUX);
    }

    public static PlatformService getInstance() {
        return PLATFORM_SERVICE;
    }

    public OS getOs() {
        return this.os;
    }

    public boolean isLinux() {
        return this.os == OS.LINUX;
    }

    public boolean isMac() {
        return this.os == OS.MAC_OSX;
    }

    public boolean isWindows() {
        return this.os == OS.WINDOWS;
    }

    public static enum OS {
        LINUX,
        MAC_OSX,
        WINDOWS;

    }
}

