/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.mainpanel;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.ContentIndexable;
import org.jd.gui.api.feature.SourcesSavable;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.spi.Indexer;
import org.jd.gui.spi.PanelFactory;
import org.jd.gui.spi.SourceSaver;
import org.jd.gui.spi.TreeNodeFactory;
import org.jd.gui.view.component.panel.TreeTabbedPanel;

public class ContainerPanelFactoryProvider
implements PanelFactory {
    protected static final String[] TYPES = new String[]{"default"};

    @Override
    public String[] getTypes() {
        return TYPES;
    }

    @Override
    public <T extends JComponent> T make(API api, Container container) {
        return (T)new ContainerPanel(api, container);
    }

    protected static class ContainerPanel
    extends TreeTabbedPanel
    implements ContentIndexable,
    SourcesSavable,
    Closeable {
        private static final long serialVersionUID = 1L;
        private transient Container.Entry entry;
        private transient Container container;

        public ContainerPanel(API api, Container container) {
            super(api, container.getRoot().getParent().getUri());
            this.container = container;
            this.entry = container.getRoot().getParent();
            DefaultMutableTreeNode root = new DefaultMutableTreeNode();
            for (Container.Entry nextEntry : container.getRoot().getChildren().values()) {
                TreeNodeFactory factory = api.getTreeNodeFactory(nextEntry);
                if (factory == null) continue;
                root.add((MutableTreeNode)factory.make(api, nextEntry));
            }
            this.tree.setModel(new DefaultTreeModel(root));
        }

        @Override
        public Indexes index(API api, DoubleSupplier getProgressFunction, DoubleConsumer setProgressFunction, BooleanSupplier isCancelledFunction) {
            HashMap<String, Map<String, Collection>> map = new HashMap<String, Map<String, Collection>>();
            DelegatedMapMapWithDefault mapWithDefault = new DelegatedMapMapWithDefault((Map<String, Map<String, Collection>>)map);
            Indexes indexesWithDefault = mapWithDefault::get;
            Indexer indexer = api.getIndexer(this.entry);
            if (indexer != null && !isCancelledFunction.getAsBoolean()) {
                indexer.index(api, this.entry, indexesWithDefault, getProgressFunction, setProgressFunction, isCancelledFunction);
            }
            return map::get;
        }

        @Override
        public String getSourceFileName() {
            SourceSaver saver = this.api.getSourceSaver(this.entry);
            if (saver != null) {
                return saver.getSourcePath(this.entry);
            }
            return null;
        }

        @Override
        public int getFileCount() {
            SourceSaver saver = this.api.getSourceSaver(this.entry);
            return saver != null ? saver.getFileCount(this.api, this.entry) : 0;
        }

        @Override
        public void save(API api, Path path, DoubleSupplier getProgressFunction, DoubleConsumer setProgressFunction, BooleanSupplier isCancelledFunction) {
            block13: {
                try {
                    Path parentPath = path.getParent();
                    if (parentPath != null && !Files.exists(parentPath, new LinkOption[0])) {
                        Files.createDirectories(parentPath, new FileAttribute[0]);
                    }
                    URI uri = path.toUri();
                    URI archiveUri = new URI("jar:" + uri.getScheme(), uri.getHost(), uri.getPath() + "!/", null);
                    try (FileSystem archiveFs = FileSystems.newFileSystem(archiveUri, Collections.singletonMap("create", "true"));){
                        Path archiveRootPath = archiveFs.getPath("/", new String[0]);
                        SourceSaver saver = api.getSourceSaver(this.entry);
                        if (saver != null) {
                            saver.saveContent(api, archiveRootPath, archiveRootPath, this.entry, getProgressFunction, setProgressFunction, isCancelledFunction);
                        }
                    }
                    catch (AccessDeniedException e) {
                        assert (ExceptionUtil.printStackTrace((Throwable)e));
                        JOptionPane.showMessageDialog(this.getParent(), "Not authorized to save to this destination. Please restart as administrator or choose another location.", "Access denied", 0);
                    }
                }
                catch (IOException | URISyntaxException e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block13;
                    throw new AssertionError();
                }
            }
        }

        @Override
        public void close() throws IOException {
            if (this.container instanceof Closeable) {
                Closeable c = (Closeable)((Object)this.container);
                c.close();
            }
        }
    }

    protected static class DelegatedMapMapWithDefault
    extends DelegatedMap<String, Map<String, Collection>> {
        private Map<String, Map<String, Collection>> wrappers = new HashMap<String, Map<String, Collection>>();

        public DelegatedMapMapWithDefault(Map<String, Map<String, Collection>> map) {
            super(map);
        }

        @Override
        public Map<String, Collection> get(Object o) {
            DelegatedMapWithDefault value = this.wrappers.get(o);
            if (value == null) {
                String key = o.toString();
                HashMap<String, Collection> m = new HashMap<String, Collection>();
                this.put(key, m);
                value = new DelegatedMapWithDefault((Map<String, Collection>)m);
                this.wrappers.put(key, value);
            }
            return value;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            return 31 * result + (this.wrappers == null ? 0 : this.wrappers.hashCode());
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj) || this.getClass() != obj.getClass()) {
                return false;
            }
            DelegatedMapMapWithDefault other = (DelegatedMapMapWithDefault)obj;
            return Objects.equals(this.wrappers, other.wrappers);
        }
    }

    protected static class DelegatedMapWithDefault
    extends DelegatedMap<String, Collection> {
        public DelegatedMapWithDefault(Map<String, Collection> map) {
            super(map);
        }

        @Override
        public Collection get(Object o) {
            ArrayList value = (ArrayList)super.get(o);
            if (value == null) {
                String key = o.toString();
                value = new ArrayList();
                this.put(key, value);
            }
            return value;
        }
    }

    protected static class DelegatedMap<K, V>
    implements Map<K, V> {
        private Map<K, V> map;

        public DelegatedMap(Map<K, V> map) {
            this.map = map;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public boolean containsKey(Object o) {
            return this.map.containsKey(o);
        }

        @Override
        public boolean containsValue(Object o) {
            return this.map.containsValue(o);
        }

        @Override
        public V get(Object o) {
            return this.map.get(o);
        }

        @Override
        public V put(K k, V v) {
            return this.map.put(k, v);
        }

        @Override
        public V remove(Object o) {
            return this.map.remove(o);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            this.map.putAll(map);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Set<K> keySet() {
            return this.map.keySet();
        }

        @Override
        public Collection<V> values() {
            return this.map.values();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.map.entrySet();
        }

        @Override
        public boolean equals(Object o) {
            return this.map.equals(o);
        }

        @Override
        public int hashCode() {
            return this.map.hashCode();
        }
    }
}

