/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.indexer;

import java.util.function.BooleanSupplier;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.service.indexer.AbstractIndexerProvider;
import org.jd.gui.spi.Indexer;

public class ZipFileIndexerProvider
extends AbstractIndexerProvider {
    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:*.zip", "*:file:*.jar", "*:file:*.war", "*:file:*.ear", "*:file:*.aar", "*:file:*.kar");
    }

    @Override
    public void index(API api, Container.Entry entry, Indexes indexes, DoubleSupplier getProgressFunction, DoubleConsumer setProgressFunction, BooleanSupplier isCancelledFunction) {
        for (Container.Entry e : entry.getChildren().values()) {
            if (e.isDirectory()) {
                this.index(api, e, indexes, getProgressFunction, setProgressFunction, isCancelledFunction);
                continue;
            }
            Indexer indexer = api.getIndexer(e);
            if (indexer == null || isCancelledFunction.getAsBoolean()) continue;
            indexer.index(api, e, indexes, getProgressFunction, setProgressFunction, isCancelledFunction);
        }
    }
}

